/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.query.lucene;

import java.io.IOException;
import java.util.List;
import org.apache.jackrabbit.core.query.lucene.PersistentIndex;
import org.apache.lucene.index.IndexCommit;
import org.apache.lucene.index.IndexDeletionPolicy;
import org.apache.lucene.store.Directory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IndexDeletionPolicyImpl
implements IndexDeletionPolicy {
    private static final String SEGMENTS = "segments";
    private final PersistentIndex index;
    private final long maxAge;

    public IndexDeletionPolicyImpl(PersistentIndex index, long maxAge) throws IOException {
        this.index = index;
        this.maxAge = maxAge;
        this.readCurrentGeneration();
    }

    public void onInit(List<? extends IndexCommit> commits) throws IOException {
        this.checkCommits(commits);
    }

    public void onCommit(List<? extends IndexCommit> commits) throws IOException {
        this.checkCommits(commits);
        IndexCommit current = commits.get(commits.size() - 1);
        String name = current.getSegmentsFileName();
        if (name.equals(SEGMENTS)) {
            this.index.setCurrentGeneration(0L);
        } else {
            this.index.setCurrentGeneration(Long.parseLong(name.substring(SEGMENTS.length() + 1), 36));
        }
    }

    private void checkCommits(List<? extends IndexCommit> commits) throws IOException {
        long currentTime = System.currentTimeMillis();
        for (int i = 0; i < commits.size() - 1; ++i) {
            IndexCommit ic = commits.get(i);
            long lastModified = this.index.getDirectory().fileModified(ic.getSegmentsFileName());
            if (currentTime - lastModified <= this.maxAge) break;
            ic.delete();
        }
    }

    void readCurrentGeneration() throws IOException {
        Directory dir = this.index.getDirectory();
        String[] names = dir.listAll();
        long max = 0L;
        if (names != null) {
            for (String name : names) {
                long gen = -1L;
                if (name.startsWith(SEGMENTS)) {
                    if (name.length() == SEGMENTS.length()) {
                        gen = 0L;
                    } else if (name.charAt(SEGMENTS.length()) == '_') {
                        gen = Long.parseLong(name.substring(SEGMENTS.length() + 1), 36);
                    }
                }
                if (gen <= max) continue;
                max = gen;
            }
        }
        this.index.setCurrentGeneration(max);
    }
}

