/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.persistence.bundle;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import java.util.Set;
import javax.jcr.RepositoryException;
import org.apache.jackrabbit.core.id.NodeId;
import org.apache.jackrabbit.core.persistence.bundle.AbstractBundlePersistenceManager;
import org.apache.jackrabbit.core.persistence.check.ConsistencyCheckListener;
import org.apache.jackrabbit.core.persistence.check.ConsistencyReport;
import org.apache.jackrabbit.core.persistence.check.ConsistencyReportImpl;
import org.apache.jackrabbit.core.persistence.check.ReportItem;
import org.apache.jackrabbit.core.persistence.check.ReportItemImpl;
import org.apache.jackrabbit.core.persistence.util.NodePropBundle;
import org.apache.jackrabbit.core.state.ItemStateException;
import org.apache.jackrabbit.spi.NameFactory;
import org.apache.jackrabbit.spi.commons.name.NameConstants;
import org.apache.jackrabbit.spi.commons.name.NameFactoryImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConsistencyCheckerImpl {
    private static Logger log = LoggerFactory.getLogger(ConsistencyCheckerImpl.class);
    private final AbstractBundlePersistenceManager pm;
    private final ConsistencyCheckListener listener;
    private static final NameFactory NF = NameFactoryImpl.getInstance();
    private static int NODESATONCE = 65536;

    public ConsistencyCheckerImpl(AbstractBundlePersistenceManager pm, ConsistencyCheckListener listener) {
        this.pm = pm;
        this.listener = listener;
    }

    public ConsistencyReport check(String[] uuids, boolean recursive, boolean fix, String lostNFoundId) throws RepositoryException {
        HashSet<ReportItem> reports = new HashSet<ReportItem>();
        long tstart = System.currentTimeMillis();
        int total = this.internalCheckConsistency(uuids, recursive, fix, reports, lostNFoundId);
        long elapsed = System.currentTimeMillis() - tstart;
        return new ConsistencyReportImpl(total, elapsed, reports);
    }

    private int internalCheckConsistency(String[] uuids, boolean recursive, boolean fix, Set<ReportItem> reports, String lostNFoundId) throws RepositoryException {
        int count = 0;
        NodeId lostNFound = null;
        if (fix && lostNFoundId != null) {
            try {
                NodeId tmpid = new NodeId(lostNFoundId);
                NodePropBundle lfBundle = this.pm.loadBundle(tmpid);
                if (lfBundle == null) {
                    this.error(lostNFoundId, "specified 'lost+found' node does not exist");
                } else if (!NameConstants.NT_UNSTRUCTURED.equals(lfBundle.getNodeTypeName())) {
                    this.error(lostNFoundId, "specified 'lost+found' node is not of type nt:unstructured");
                } else {
                    lostNFound = lfBundle.getId();
                }
            }
            catch (Exception ex) {
                this.error(lostNFoundId, "finding 'lost+found' folder", ex);
            }
        }
        if (uuids == null) {
            try {
                List<NodeId> allIds = this.pm.getAllNodeIds(null, NODESATONCE);
                while (!allIds.isEmpty()) {
                    NodeId lastId = null;
                    Iterator<NodeId> i$ = allIds.iterator();
                    while (i$.hasNext()) {
                        NodeId id;
                        lastId = id = i$.next();
                        try {
                            NodePropBundle bundle = this.pm.loadBundle(id);
                            if (bundle == null) {
                                this.error(id.toString(), "No bundle found for id '" + id + "'");
                                continue;
                            }
                            this.checkBundleConsistency(id, bundle, fix, lostNFound, reports);
                            if (++count % 1000 != 0 || this.listener != null) continue;
                            log.info(this.pm + ": checked " + count + " bundles...");
                        }
                        catch (ItemStateException e) {}
                    }
                    if (allIds.isEmpty()) continue;
                    allIds = this.pm.getAllNodeIds(lastId, NODESATONCE);
                }
            }
            catch (ItemStateException ex) {
                throw new RepositoryException("getting nodeIds", (Throwable)ex);
            }
        } else {
            int i;
            ArrayList<NodeId> idList = new ArrayList<NodeId>(uuids.length);
            for (i = 0; i < uuids.length; ++i) {
                try {
                    idList.add(new NodeId(uuids[i]));
                    continue;
                }
                catch (IllegalArgumentException e) {
                    this.error(uuids[i], "Invalid id for consistency check, skipping: '" + uuids[i] + "': " + e);
                }
            }
            for (i = 0; i < idList.size(); ++i) {
                NodeId id = (NodeId)idList.get(i);
                try {
                    NodePropBundle bundle = this.pm.loadBundle(id);
                    if (bundle == null) {
                        if (this.isVirtualNode(id)) continue;
                        this.error(id.toString(), "No bundle found for id '" + id + "'");
                        continue;
                    }
                    this.checkBundleConsistency(id, bundle, fix, lostNFound, reports);
                    if (recursive) {
                        for (NodePropBundle.ChildNodeEntry entry : bundle.getChildNodeEntries()) {
                            idList.add(entry.getId());
                        }
                    }
                    if (++count % 1000 != 0 || this.listener != null) continue;
                    log.info(this.pm + ": checked " + count + "/" + idList.size() + " bundles...");
                    continue;
                }
                catch (ItemStateException e) {
                    // empty catch block
                }
            }
        }
        log.info(this.pm + ": checked " + count + " bundles.");
        return count;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void checkBundleConsistency(NodeId id, NodePropBundle bundle, boolean fix, NodeId lostNFoundId, Set<ReportItem> reports) {
        String message;
        if (this.isVirtualNode(id)) {
            return;
        }
        if (this.listener != null) {
            this.listener.startCheck(id.toString());
        }
        ArrayList<NodePropBundle.ChildNodeEntry> missingChildren = new ArrayList<NodePropBundle.ChildNodeEntry>();
        ArrayList<NodePropBundle.ChildNodeEntry> disconnectedChildren = new ArrayList<NodePropBundle.ChildNodeEntry>();
        for (NodePropBundle.ChildNodeEntry entry : bundle.getChildNodeEntries()) {
            NodeId childNodeId = entry.getId();
            if (childNodeId.toString().endsWith("babecafebabe")) continue;
            try {
                NodePropBundle childBundle = this.pm.loadBundle(childNodeId);
                String message2 = null;
                if (childBundle == null) {
                    bundle = this.pm.loadBundle(id);
                    if (bundle == null) return;
                    boolean stillThere = false;
                    for (NodePropBundle.ChildNodeEntry entryRetry : bundle.getChildNodeEntries()) {
                        if (!entryRetry.getId().equals(childNodeId)) continue;
                        stillThere = true;
                        break;
                    }
                    if (stillThere) {
                        message2 = "NodeState '" + id + "' references inexistent child" + " '" + entry.getName() + "' with id " + "'" + childNodeId + "'";
                        log.error(message2);
                        missingChildren.add(entry);
                    }
                } else {
                    NodeId cp = childBundle.getParentId();
                    if (!id.equals(cp)) {
                        bundle = this.pm.loadBundle(id);
                        if (bundle == null) return;
                        boolean stillThere = false;
                        for (NodePropBundle.ChildNodeEntry entryRetry : bundle.getChildNodeEntries()) {
                            if (!entryRetry.getId().equals(childNodeId)) continue;
                            stillThere = true;
                            break;
                        }
                        if (stillThere) {
                            message2 = "ChildNode has invalid parent id: '" + cp + "' (instead of '" + id + "')";
                            log.error(message2);
                            disconnectedChildren.add(entry);
                        }
                    }
                }
                if (message2 == null) continue;
                this.addMessage(reports, id, message2);
            }
            catch (ItemStateException e) {
                this.addMessage(reports, id, e.getMessage());
            }
        }
        if (!(!fix || missingChildren.isEmpty() && disconnectedChildren.isEmpty())) {
            for (NodePropBundle.ChildNodeEntry entry : missingChildren) {
                bundle.getChildNodeEntries().remove(entry);
            }
            for (NodePropBundle.ChildNodeEntry entry : disconnectedChildren) {
                bundle.getChildNodeEntries().remove(entry);
            }
            this.fixBundle(bundle);
        }
        NodeId parentId = bundle.getParentId();
        try {
            if (parentId == null) return;
            if (id.toString().endsWith("babecafebabe")) return;
            NodePropBundle parentBundle = this.pm.loadBundle(parentId);
            if (parentBundle == null) {
                bundle = this.pm.loadBundle(id);
                if (bundle == null) return;
                if (!parentId.equals(bundle.getParentId())) return;
                message = "NodeState '" + id + "' references inexistent parent id '" + parentId + "'";
                log.error(message);
                this.addMessage(reports, id, message);
                if (!fix) return;
                if (lostNFoundId == null) return;
                NodePropBundle lfBundle = this.pm.loadBundle(lostNFoundId);
                lfBundle.markOld();
                String nodeName = id + "-" + System.currentTimeMillis();
                lfBundle.addChildNodeEntry(NF.create("", nodeName), id);
                this.pm.storeBundle(lfBundle);
                this.pm.evictBundle(lostNFoundId);
                bundle.setParentId(lostNFoundId);
                this.fixBundle(bundle);
                return;
            } else {
                boolean found = false;
                for (NodePropBundle.ChildNodeEntry entry : parentBundle.getChildNodeEntries()) {
                    if (!entry.getId().equals(id)) continue;
                    return;
                }
                if (found) return;
                bundle = this.pm.loadBundle(id);
                if (bundle == null) return;
                if (!parentId.equals(bundle.getParentId())) return;
                String message3 = "NodeState '" + id + "' is not referenced by its parent node '" + parentId + "'";
                log.error(message3);
                this.addMessage(reports, id, message3);
                if (!fix) return;
                int l = (int)System.currentTimeMillis();
                int r = new Random().nextInt();
                int n = l + r;
                String nodeName = Integer.toHexString(n);
                parentBundle.addChildNodeEntry(NF.create("{}" + nodeName), id);
                log.info("NodeState '" + id + "' adds itself to its parent node '" + parentId + "' with a new name '" + nodeName + "'");
                this.fixBundle(parentBundle);
            }
            return;
        }
        catch (ItemStateException e) {
            message = "Error reading node '" + parentId + "' (parent of '" + id + "'): " + e;
            log.error(message);
            this.addMessage(reports, id, message);
        }
    }

    private boolean isVirtualNode(NodeId id) {
        String s = id.toString();
        if ("cafebabe-cafe-babe-cafe-babecafebabe".equals(s)) {
            return false;
        }
        return s.endsWith("babecafebabe");
    }

    private void addMessage(Set<ReportItem> reports, NodeId id, String message) {
        if (reports != null || this.listener != null) {
            ReportItemImpl ri = new ReportItemImpl(id.toString(), message);
            if (reports != null) {
                reports.add(ri);
            }
            if (this.listener != null) {
                this.listener.report(ri);
            }
        }
    }

    private void info(String id, String message) {
        if (this.listener == null) {
            String idstring = id == null ? "" : "Node " + id + ": ";
            log.info(idstring + message);
        } else {
            this.listener.info(id, message);
        }
    }

    private void error(String id, String message) {
        if (this.listener == null) {
            String idstring = id == null ? "" : "Node " + id + ": ";
            log.error(idstring + message);
        } else {
            this.listener.error(id, message);
        }
    }

    private void error(String id, String message, Throwable ex) {
        String idstring = id == null ? "" : "Node " + id + ": ";
        log.error(idstring + message, ex);
        if (this.listener != null) {
            this.listener.error(id, message);
        }
    }

    private void fixBundle(NodePropBundle bundle) {
        try {
            log.info(this.pm + ": Fixing bundle '" + bundle.getId() + "'");
            bundle.markOld();
            this.pm.storeBundle(bundle);
            this.pm.evictBundle(bundle.getId());
        }
        catch (ItemStateException e) {
            log.error(this.pm + ": Error storing fixed bundle: " + e);
        }
    }
}

