/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.observation;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.jcr.RepositoryException;
import javax.jcr.observation.Event;
import org.apache.jackrabbit.api.observation.JackrabbitEvent;
import org.apache.jackrabbit.core.SessionImpl;
import org.apache.jackrabbit.core.id.NodeId;
import org.apache.jackrabbit.core.observation.EventState;
import org.apache.jackrabbit.core.value.InternalValue;
import org.apache.jackrabbit.spi.Name;
import org.apache.jackrabbit.spi.Path;
import org.apache.jackrabbit.spi.QValue;
import org.apache.jackrabbit.spi.commons.AdditionalEventInfo;
import org.apache.jackrabbit.spi.commons.conversion.MalformedPathException;
import org.apache.jackrabbit.spi.commons.conversion.NamePathResolver;
import org.apache.jackrabbit.spi.commons.name.PathFactoryImpl;
import org.apache.jackrabbit.spi.commons.value.ValueFormat;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class EventImpl
implements JackrabbitEvent,
AdditionalEventInfo,
Event {
    private static final Logger log = LoggerFactory.getLogger(EventImpl.class);
    private final SessionImpl session;
    private final EventState eventState;
    private final long timestamp;
    private final String userData;
    private String stringValue;

    EventImpl(SessionImpl session, EventState eventState, long timestamp, String userData) {
        this.session = session;
        this.eventState = eventState;
        this.timestamp = timestamp;
        this.userData = userData;
    }

    public int getType() {
        return this.eventState.getType();
    }

    public String getPath() throws RepositoryException {
        Path p = this.getQPath();
        return p != null ? this.session.getJCRPath(this.getQPath()) : null;
    }

    public String getUserID() {
        return this.eventState.getUserId();
    }

    public long getDate() {
        return this.timestamp;
    }

    public String getUserData() {
        return this.userData;
    }

    public String getIdentifier() throws RepositoryException {
        if (this.eventState.getType() == 64) {
            return null;
        }
        NodeId id = this.eventState.getChildId();
        if (id != null) {
            return id.toString();
        }
        return this.eventState.getParentId().toString();
    }

    public Map<String, String> getInfo() throws RepositoryException {
        HashMap<String, String> info = new HashMap<String, String>();
        for (Map.Entry<String, InternalValue> entry : this.eventState.getInfo().entrySet()) {
            InternalValue value = entry.getValue();
            String strValue = null;
            if (value != null) {
                strValue = ValueFormat.getJCRString((QValue)value, (NamePathResolver)this.session);
            }
            info.put(entry.getKey(), strValue);
        }
        return info;
    }

    public Path getQPath() throws RepositoryException {
        try {
            Path parent = this.eventState.getParentPath();
            Path child = this.eventState.getChildRelPath();
            if (parent == null || child == null) {
                return null;
            }
            int index = child.getIndex();
            if (index > 0) {
                return PathFactoryImpl.getInstance().create(parent, child.getName(), index, false);
            }
            return PathFactoryImpl.getInstance().create(parent, child.getName(), false);
        }
        catch (MalformedPathException e) {
            String msg = "internal error: malformed path for event";
            log.debug(msg);
            throw new RepositoryException(msg, (Throwable)e);
        }
    }

    public NodeId getParentId() {
        return this.eventState.getParentId();
    }

    public NodeId getChildId() {
        return this.eventState.getChildId();
    }

    public boolean isShareableChildNode() {
        return this.eventState.isShareableNode();
    }

    public boolean isExternal() {
        return this.eventState.isExternal();
    }

    public Name getPrimaryNodeTypeName() {
        return this.eventState.getNodeType();
    }

    public Set<Name> getMixinTypeNames() {
        return this.eventState.getMixinNames();
    }

    public Object getSessionAttribute(String name) {
        return this.eventState.getSession().getAttribute(name);
    }

    public String toString() {
        if (this.stringValue == null) {
            StringBuilder sb = new StringBuilder();
            sb.append("Event: Path: ");
            try {
                sb.append(this.getPath());
            }
            catch (RepositoryException e) {
                log.error("Exception retrieving path: " + (Object)((Object)e));
                sb.append("[Error retrieving path]");
            }
            sb.append(", ").append(EventState.valueOf(this.getType())).append(": ");
            sb.append(", UserId: ").append(this.getUserID());
            sb.append(", Timestamp: ").append(this.timestamp);
            sb.append(", UserData: ").append(this.userData);
            sb.append(", Info: ").append(this.eventState.getInfo());
            this.stringValue = sb.toString();
        }
        return this.stringValue;
    }

    public int hashCode() {
        int h = this.eventState.hashCode() ^ new Long(this.timestamp).hashCode() ^ ((Object)((Object)this.session)).hashCode();
        if (this.userData != null) {
            h ^= this.userData.hashCode();
        }
        return h;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof EventImpl) {
            EventImpl other = (EventImpl)obj;
            return this.eventState.equals(other.eventState) && ((Object)((Object)this.session)).equals((Object)other.session) && this.timestamp == other.timestamp && EventImpl.equals(this.userData, other.userData);
        }
        return false;
    }

    private static boolean equals(Object o1, Object o2) {
        if (o1 == null) {
            return o2 == null;
        }
        return o1.equals(o2);
    }
}

