/*
 * Decompiled with CFR 0.152.
 */
package it.sauronsoftware.feed4j;

import it.sauronsoftware.feed4j.TypeAbstract;
import java.util.Iterator;
import org.dom4j.Document;
import org.dom4j.Element;
import org.dom4j.Namespace;

class FeedRecognizer
extends TypeAbstract {
    public static final int UNKNOWN = -1;
    public static final int RSS_1_0 = 0;
    public static final int RSS_2_0 = 1;
    public static final int ATOM_0_3 = 2;
    public static final int ATOM_1_0 = 3;

    FeedRecognizer() {
    }

    public static int recognizeFeed(Document document) {
        Element root = document.getRootElement();
        if (root == null) {
            return -1;
        }
        Namespace namespace = root.getNamespace();
        String nsuri = namespace != null ? namespace.getURI() : null;
        String name = root.getName();
        if ("rss".equals(name)) {
            String version = root.attributeValue("version");
            if (version == null || version.equals("2.0") || version.equals("0.91") || version.equals("0.92")) {
                return 1;
            }
        } else if ("RDF".equals(name) && "http://www.w3.org/1999/02/22-rdf-syntax-ns#".equals(nsuri)) {
            Iterator i = root.elementIterator();
            while (i.hasNext()) {
                Element element = (Element)i.next();
                String elNsUri = element.getNamespaceURI();
                if (!"http://purl.org/rss/1.0/".equals(elNsUri)) continue;
                return 0;
            }
        } else if (name.equals("feed")) {
            String version = root.attributeValue("version");
            if (version == null || version.equals("1.0") || "http://www.w3.org/2005/Atom".equals(nsuri)) {
                return 3;
            }
            if (version.equals("0.3") || "http://purl.org/atom/ns#".equals(nsuri)) {
                return 2;
            }
        }
        return -1;
    }
}

