/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.jfreereport.wizard.utility;

import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.Writer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.exolab.castor.xml.Marshaller;
import org.exolab.castor.xml.Unmarshaller;

public class CastorUtility {
    private static CastorUtility instance;

    public static Log getLogger() {
        return LogFactory.getLog(CastorUtility.class);
    }

    public static CastorUtility getInstance() {
        if (instance == null) {
            instance = new CastorUtility();
        }
        return instance;
    }

    public Object readCastorObject(String inputFileName, Class expectedClass) {
        Object o = null;
        try {
            o = Unmarshaller.unmarshal((Class)expectedClass, (Reader)new FileReader(inputFileName));
        }
        catch (Exception e) {
            CastorUtility.getLogger().error((Object)e.getMessage(), (Throwable)e);
        }
        return o;
    }

    public Object readCastorObject(InputStream inputStream, Class expectedClass, String encoding) {
        Object o = null;
        try {
            InputStreamReader reader = null;
            reader = null != encoding ? new InputStreamReader(inputStream, encoding) : new InputStreamReader(inputStream);
            o = Unmarshaller.unmarshal((Class)expectedClass, (Reader)reader);
        }
        catch (Exception e) {
            CastorUtility.getLogger().error((Object)e.getMessage(), (Throwable)e);
        }
        return o;
    }

    public Object readCastorObject(InputStream inputStream, Class expectedClass) {
        return this.readCastorObject(inputStream, expectedClass, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public File writeCastorObject(Object object, String outputFileName) {
        File file = null;
        Writer fileWriter = null;
        try {
            file = new File(outputFileName);
            fileWriter = new FileWriter(file);
            Marshaller.marshal((Object)object, (Writer)fileWriter);
            fileWriter.close();
        }
        catch (Exception e) {
            CastorUtility.getLogger().error((Object)e.getMessage(), (Throwable)e);
        }
        finally {
            try {
                fileWriter.flush();
            }
            catch (Exception ignored) {}
            try {
                fileWriter.close();
            }
            catch (Exception ignored) {}
        }
        return file;
    }
}

