/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.jfreereport.castormodel.jfree.types;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class Fontstyle
implements Serializable {
    public static final int PLAIN_TYPE = 0;
    public static final Fontstyle PLAIN = new Fontstyle(0, "plain");
    public static final int BOLD_TYPE = 1;
    public static final Fontstyle BOLD = new Fontstyle(1, "bold");
    public static final int ITALIC_TYPE = 2;
    public static final Fontstyle ITALIC = new Fontstyle(2, "italic");
    public static final int BOLD_ITALIC_TYPE = 3;
    public static final Fontstyle BOLD_ITALIC = new Fontstyle(3, "bold-italic");
    private static Hashtable _memberTable = Fontstyle.init();
    private int type = -1;
    private String stringValue = null;
    private Vector propertyChangeListeners;

    private Fontstyle(int type, String value) {
        this.type = type;
        this.stringValue = value;
        this.propertyChangeListeners = new Vector();
    }

    public void addPropertyChangeListener(PropertyChangeListener pcl) {
        this.propertyChangeListeners.addElement(pcl);
    }

    public static Enumeration enumerate() {
        return _memberTable.elements();
    }

    public int getType() {
        return this.type;
    }

    protected void notifyPropertyChangeListeners(String fieldName, Object oldValue, Object newValue) {
        if (this.propertyChangeListeners == null) {
            return;
        }
        PropertyChangeEvent event = new PropertyChangeEvent(this, fieldName, oldValue, newValue);
        for (int i = 0; i < this.propertyChangeListeners.size(); ++i) {
            ((PropertyChangeListener)this.propertyChangeListeners.elementAt(i)).propertyChange(event);
        }
    }

    public boolean removePropertyChangeListener(PropertyChangeListener pcl) {
        return this.propertyChangeListeners.removeElement(pcl);
    }

    private static Hashtable init() {
        Hashtable<String, Fontstyle> members = new Hashtable<String, Fontstyle>();
        members.put("plain", PLAIN);
        members.put("bold", BOLD);
        members.put("italic", ITALIC);
        members.put("bold-italic", BOLD_ITALIC);
        return members;
    }

    private Object readResolve() {
        return Fontstyle.valueOf(this.stringValue);
    }

    public String toString() {
        return this.stringValue;
    }

    public static Fontstyle valueOf(String string) {
        Object obj = null;
        if (string != null) {
            obj = _memberTable.get(string);
        }
        if (obj == null) {
            String err = "'" + string + "' is not a valid Fontstyle";
            throw new IllegalArgumentException(err);
        }
        return obj;
    }
}

