/*
 * Decompiled with CFR 0.152.
 */
package pt.webdetails.cpf;

import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URLDecoder;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.TimeoutException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import mondrian.olap.QueryTimeoutException;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.json.JSONException;
import org.pentaho.platform.api.engine.ILogger;
import org.pentaho.platform.api.engine.IMimeTypeListener;
import org.pentaho.platform.api.engine.IParameterProvider;
import org.pentaho.platform.api.repository.IContentItem;
import org.pentaho.platform.engine.core.system.PentahoSessionHolder;
import org.pentaho.platform.engine.security.SecurityHelper;
import org.pentaho.platform.engine.services.solution.BaseContentGenerator;
import org.springframework.security.GrantedAuthority;
import org.springframework.security.GrantedAuthorityImpl;
import pt.webdetails.cpf.annotations.AccessLevel;
import pt.webdetails.cpf.annotations.Audited;
import pt.webdetails.cpf.annotations.Exposed;
import pt.webdetails.cpf.audit.CpfAuditHelper;
import pt.webdetails.cpf.messaging.JsonSerializable;
import pt.webdetails.cpf.utils.CharsetHelper;

public abstract class SimpleContentGenerator
extends BaseContentGenerator {
    private static final long serialVersionUID = 1L;
    protected Log logger = LogFactory.getLog(((Object)((Object)this)).getClass());
    protected static final String ENCODING = CharsetHelper.getEncoding();
    protected static final EnumMap<FileType, String> mimeTypes = new EnumMap(FileType.class);

    protected static String getEncoding() {
        return ENCODING;
    }

    protected String getMimeType(String fileName) {
        String[] fileNameSplit = StringUtils.split((String)fileName, (char)'.');
        try {
            return this.getMimeType(FileType.valueOf(fileNameSplit[fileNameSplit.length - 1].toUpperCase()));
        }
        catch (Exception e) {
            this.logger.warn((Object)("Unrecognized extension for file name " + fileName));
            return "";
        }
    }

    protected String getMimeType(FileType fileType) {
        if (fileType == null) {
            return "";
        }
        String mimeType = mimeTypes.get((Object)fileType);
        return mimeType == null ? "" : mimeType;
    }

    public void createContent() throws Exception {
        IParameterProvider pathParams = this.getPathParameters();
        try {
            String path = pathParams.getStringParameter("path", null);
            String[] pathSections = StringUtils.split((String)path, (String)"/");
            if (pathSections == null || pathSections.length == 0) {
                String method = this.getDefaultPath(path);
                if (!StringUtils.isEmpty((String)method)) {
                    this.logger.warn((Object)"No method supplied, redirecting.");
                    this.redirect(method);
                } else {
                    this.logger.error((Object)"No method supplied.");
                }
            } else {
                String methodName = pathSections[0];
                try {
                    Method method = this.getMethod(methodName);
                    this.invokeMethod(methodName, method);
                }
                catch (NoSuchMethodException e) {
                    String msg = "couldn't locate method: " + methodName;
                    this.logger.warn((Object)msg);
                    this.getResponse().sendError(404, msg);
                }
                catch (InvocationTargetException e) {
                    Throwable cause = e.getCause();
                    if (cause == null) {
                        cause = e;
                    }
                    this.handleError(methodName, cause);
                }
                catch (Exception e) {
                    this.handleError(methodName, e);
                }
            }
        }
        catch (SecurityException e) {
            this.logger.warn((Object)e.toString());
        }
    }

    private void handleError(String methodName, Throwable e) throws IOException {
        this.logger.error((Object)(methodName + ": " + e.getMessage()), e);
        String msg = e.getLocalizedMessage();
        if (e instanceof QueryTimeoutException || e instanceof TimeoutException) {
            this.getResponse().sendError(408, msg);
        } else {
            this.getResponse().sendError(500, msg);
        }
    }

    protected Method getMethod(String methodName) throws NoSuchMethodException {
        Class<?>[] params = this.getCGMethodParams();
        Method method = ((Object)((Object)this)).getClass().getMethod(methodName, params);
        return method;
    }

    public abstract String getPluginName();

    public String getPluginPath() {
        return null;
    }

    protected static Map<String, Method> getExposedMethods(Class<?> classe, boolean lowerCase) {
        HashMap<String, Method> exposedMethods = new HashMap<String, Method>();
        Log log = LogFactory.getLog(classe);
        for (Method method : classe.getMethods()) {
            if (method.getAnnotation(Exposed.class) == null) continue;
            String methodKey = method.getName().toLowerCase();
            if (exposedMethods.containsKey(methodKey)) {
                log.error((Object)("Method " + method + " differs from " + exposedMethods.get(methodKey) + " only in case and will override calls to it!!"));
            }
            log.debug((Object)("registering " + classe.getSimpleName() + "." + method.getName()));
            exposedMethods.put(methodKey, method);
        }
        return exposedMethods;
    }

    protected Class<?>[] getCGMethodParams() {
        return new Class[]{OutputStream.class};
    }

    protected OutputStream getResponseOutputStream(String mimeType) throws IOException {
        IContentItem contentItem = this.outputHandler.getOutputContentItem("response", "content", this.instanceId, mimeType);
        return contentItem.getOutputStream(null);
    }

    protected HttpServletRequest getRequest() {
        return (HttpServletRequest)((IParameterProvider)this.parameterProviders.get("path")).getParameter("httprequest");
    }

    protected HttpServletResponse getResponse() {
        return (HttpServletResponse)((IParameterProvider)this.parameterProviders.get("path")).getParameter("httpresponse");
    }

    protected IParameterProvider getRequestParameters() {
        return (IParameterProvider)this.parameterProviders.get("request");
    }

    protected IParameterProvider getPathParameters() {
        return (IParameterProvider)this.parameterProviders.get("path");
    }

    protected String getRequestParameterAsString(String parameter, String defaultValue) throws UnsupportedEncodingException {
        return this.getRequestParameterAsString(parameter, defaultValue, CharsetHelper.getEncoding());
    }

    protected String getRequestParameterAsString(String parameter, String defaultValue, String encoding) throws UnsupportedEncodingException {
        String enc;
        String string = enc = StringUtils.isEmpty((String)encoding) ? CharsetHelper.getEncoding() : encoding;
        if (this.getRequestParameters() != null && this.getRequestParameters().hasParameter(parameter)) {
            return URLDecoder.decode(this.getRequestParameters().getStringParameter(parameter, defaultValue), enc);
        }
        return defaultValue;
    }

    protected String getPathParameterAsString(String parameter, String defaultValue) throws UnsupportedEncodingException {
        return this.getPathParameterAsString(parameter, defaultValue, CharsetHelper.getEncoding());
    }

    protected String getPathParameterAsString(String parameter, String defaultValue, String encoding) throws UnsupportedEncodingException {
        String enc;
        String string = enc = StringUtils.isEmpty((String)encoding) ? CharsetHelper.getEncoding() : encoding;
        if (this.getPathParameters() != null && this.getPathParameters().hasParameter(parameter)) {
            return URLDecoder.decode(this.getPathParameters().getStringParameter(parameter, defaultValue), enc);
        }
        return defaultValue;
    }

    protected String getDefaultPath(String path) {
        return null;
    }

    private boolean canAccessMethod(Method method, Exposed exposed) {
        AccessLevel accessLevel;
        if (exposed != null && (accessLevel = exposed.accessLevel()) != null) {
            boolean accessible = false;
            switch (accessLevel) {
                case ADMIN: {
                    accessible = SecurityHelper.getInstance().isPentahoAdministrator(PentahoSessionHolder.getSession());
                    break;
                }
                case ROLE: {
                    String role = exposed.role();
                    if (StringUtils.isEmpty((String)role)) break;
                    accessible = SecurityHelper.getInstance().isGranted(PentahoSessionHolder.getSession(), (GrantedAuthority)new GrantedAuthorityImpl(role));
                    break;
                }
                case PUBLIC: {
                    accessible = true;
                    break;
                }
                default: {
                    this.logger.error((Object)("Unsupported AccessLevel " + (Object)((Object)accessLevel)));
                }
            }
            return accessible;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean invokeMethod(String methodName, Method method) throws InvocationTargetException, IllegalArgumentException, IllegalAccessException, IOException {
        Exposed exposed = method.getAnnotation(Exposed.class);
        if (this.canAccessMethod(method, exposed)) {
            Audited audited = method.getAnnotation(Audited.class);
            UUID uuid = null;
            long start = System.currentTimeMillis();
            if (audited != null) {
                uuid = CpfAuditHelper.startAudit(this.getPluginName(), audited.action(), this.getObjectName(), this.userSession, (ILogger)this, this.getRequestParameters());
            }
            OutputStream out = this.getResponseOutputStream(exposed.outputType());
            this.setResponseHeaders(exposed.outputType());
            try {
                method.invoke((Object)this, out);
            }
            finally {
                if (audited != null) {
                    CpfAuditHelper.endAudit(this.getPluginName(), audited.action(), this.getObjectName(), this.userSession, (ILogger)this, start, uuid, System.currentTimeMillis());
                }
            }
            return true;
        }
        String msg = "Method " + methodName + " not exposed or user does not have required permissions.";
        this.logger.error((Object)msg);
        this.getResponse().sendError(403, msg);
        return false;
    }

    protected void redirect(String method) {
        HttpServletResponse response = (HttpServletResponse)((IParameterProvider)this.parameterProviders.get("path")).getParameter("httpresponse");
        if (response == null) {
            this.logger.error((Object)"response not found");
            return;
        }
        try {
            response.sendRedirect(method);
        }
        catch (IOException e) {
            this.logger.error((Object)"could not redirect", (Throwable)e);
        }
    }

    protected void writeOut(OutputStream out, String contents) throws IOException {
        IOUtils.write((String)contents, (OutputStream)out, (String)SimpleContentGenerator.getEncoding());
    }

    protected void writeOut(OutputStream out, JsonSerializable contents) throws IOException, JSONException {
        IOUtils.write((String)contents.toJSON().toString(), (OutputStream)out, (String)SimpleContentGenerator.getEncoding());
    }

    public Log getLogger() {
        return this.logger;
    }

    protected void setResponseHeaders(String mimeType) {
        this.setResponseHeaders(mimeType, 0, null);
    }

    protected void setResponseHeaders(String mimeType, String attachmentName) {
        this.setResponseHeaders(mimeType, 0, attachmentName);
    }

    protected void setResponseHeaders(String mimeType, int cacheDuration, String attachmentName) {
        HttpServletResponse response;
        IMimeTypeListener mimeTypeListener = this.outputHandler.getMimeTypeListener();
        if (mimeTypeListener != null) {
            mimeTypeListener.setMimeType(mimeType);
        }
        if ((response = this.getResponse()) == null) {
            this.logger.warn((Object)"Parameter 'httpresponse' not found!");
            return;
        }
        response.setHeader("Content-Type", mimeType);
        if (attachmentName != null) {
            response.setHeader("content-disposition", "attachment; filename=" + attachmentName);
        }
        if (cacheDuration > 0) {
            response.setHeader("Cache-Control", "max-age=" + cacheDuration);
        } else {
            response.setHeader("Cache-Control", "max-age=0, no-store");
        }
    }

    protected void copyParametersFromProvider(Map<String, Object> params, IParameterProvider provider) {
        Iterator paramNames = provider.getParameterNames();
        while (paramNames.hasNext()) {
            String paramName = (String)paramNames.next();
            params.put(paramName, provider.getParameter(paramName));
        }
    }

    static {
        mimeTypes.put(FileType.JPG, "img/jpeg");
        mimeTypes.put(FileType.JPEG, "img/jpeg");
        mimeTypes.put(FileType.PNG, "image/png");
        mimeTypes.put(FileType.GIF, "image/gif");
        mimeTypes.put(FileType.BMP, "image/bmp");
        mimeTypes.put(FileType.JS, "text/javascript");
        mimeTypes.put(FileType.HTM, "text/html");
        mimeTypes.put(FileType.HTML, "text/html");
        mimeTypes.put(FileType.CSS, "text/css");
        mimeTypes.put(FileType.XML, "text/xml");
        mimeTypes.put(FileType.TXT, "text/plain");
    }

    public static class MimeType {
        public static final String CSS = "text/css";
        public static final String JAVASCRIPT = "text/javascript";
        public static final String PLAIN_TEXT = "text/plain";
        public static final String HTML = "text/html";
        public static final String XML = "text/xml";
        public static final String JPEG = "img/jpeg";
        public static final String PNG = "image/png";
        public static final String GIF = "image/gif";
        public static final String BMP = "image/bmp";
        public static final String JSON = "application/json";
        public static final String PDF = "application/pdf";
        public static final String DOC = "application/msword";
        public static final String DOCX = "application/msword";
        public static final String XLS = "application/msexcel";
        public static final String XLSX = "application/msexcel";
        public static final String PPT = "application/mspowerpoint";
        public static final String PPTX = "application/mspowerpoint";
    }

    public static enum FileType {
        JPG,
        JPEG,
        PNG,
        GIF,
        BMP,
        JS,
        CSS,
        HTML,
        HTM,
        XML,
        SVG,
        PDF,
        TXT,
        DOC,
        DOCX,
        XLS,
        XLSX,
        PPT,
        PPTX;


        public static FileType parse(String value) {
            return FileType.valueOf(StringUtils.upperCase((String)value));
        }
    }
}

