/*
 * Decompiled with CFR 0.152.
 */
package pt.webdetails.cpf;

import org.apache.commons.lang.StringUtils;
import org.pentaho.platform.util.web.MimeHelper;
import pt.webdetails.cpf.utils.MimeTypes;

public class MimeTypeHandler {
    public static String getMimeTypeFromFileType(MimeTypes.FileType fileType) {
        return MimeTypeHandler.getMimeTypeFromFileType(fileType, null);
    }

    public static String getMimeTypeFromFileType(MimeTypes.FileType fileType, String defaultMimeType) {
        return MimeTypeHandler.getMimeTypeFromExtension(fileType.toString(), defaultMimeType);
    }

    public static String getMimeTypeFromExtension(String extension) {
        return MimeTypeHandler.getMimeTypeFromExtension(extension, null);
    }

    public static String getMimeTypeFromExtension(String extension, String defaultMimeType) {
        if (StringUtils.isEmpty((String)extension)) {
            return defaultMimeType;
        }
        String resolvedMimeType = MimeHelper.getMimeTypeFromExtension((String)(extension.startsWith(".") ? extension : "." + extension));
        if (StringUtils.isEmpty((String)resolvedMimeType)) {
            resolvedMimeType = MimeTypes.getMimeTypeFromExt((String)(extension.startsWith(".") ? extension.replaceFirst(".", "") : extension));
        }
        return !StringUtils.isEmpty((String)resolvedMimeType) ? resolvedMimeType : defaultMimeType;
    }

    public static String getMimeTypeFromFileName(String filename) {
        return MimeTypeHandler.getMimeTypeFromFileName(filename, null);
    }

    public static String getMimeTypeFromFileName(String filename, String defaultMimeType) {
        String resolvedMimeType = MimeHelper.getMimeTypeFromFileName((String)filename);
        if (StringUtils.isEmpty((String)resolvedMimeType)) {
            resolvedMimeType = MimeTypes.getMimeType((String)filename);
        }
        return !StringUtils.isEmpty((String)resolvedMimeType) ? resolvedMimeType : defaultMimeType;
    }
}

