/*
 * Decompiled with CFR 0.152.
 */
package pt.webdetails.cpf.repository;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import pt.webdetails.cpf.repository.IRepositoryFile;

public class RepositoryFileExplorer {
    private static final Log logger = LogFactory.getLog(RepositoryFileExplorer.class);

    public static String toJQueryFileTree(String baseDir, IRepositoryFile[] files) {
        StringBuilder out = new StringBuilder();
        out.append("<ul class=\"jqueryFileTree\" style=\"display: none;\">");
        for (IRepositoryFile file : files) {
            if (!file.isDirectory()) continue;
            out.append("<li class=\"directory collapsed\"><a href=\"#\" rel=\"" + baseDir + file.getFileName() + "/\">" + file.getFileName() + "</a></li>");
        }
        for (IRepositoryFile file : files) {
            if (file.isDirectory()) continue;
            int dotIndex = file.getFileName().lastIndexOf(46);
            String ext = dotIndex > 0 ? file.getFileName().substring(dotIndex + 1) : "";
            out.append("<li class=\"file ext_" + ext + "\"><a href=\"#\" rel=\"" + baseDir + file.getFileName() + "\">" + file.getFileName() + "</a></li>");
        }
        out.append("</ul>");
        return out.toString();
    }

    public static String toJSON(String baseDir, IRepositoryFile[] files) {
        JSONArray arr = new JSONArray();
        for (IRepositoryFile file : files) {
            JSONObject json = new JSONObject();
            try {
                json.put("path", (Object)baseDir);
                json.put("name", (Object)file.getFileName());
                json.put("label", (Object)file.getFileName());
                if (file.isDirectory()) {
                    json.put("type", (Object)"dir");
                } else {
                    int dotIndex = file.getFileName().lastIndexOf(46);
                    String ext = dotIndex > 0 ? file.getFileName().substring(dotIndex + 1) : "";
                    json.put("ext", (Object)ext);
                    json.put("type", (Object)"file");
                }
                arr.put((Object)json);
            }
            catch (JSONException e) {
                logger.error((Object)e);
            }
        }
        return arr.toString();
    }
}

