/*
 * Decompiled with CFR 0.152.
 */
package pt.webdetails.cpk.utils;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.commons.vfs.FileName;
import org.apache.commons.vfs.FileObject;
import org.apache.commons.vfs.FileType;
import org.pentaho.di.core.ResultFile;

public class ZipUtil {
    private String zipName;
    private FileInputStream fis;
    private FileName topFilename;
    ArrayList<String> fileListing = new ArrayList();
    protected Log logger = LogFactory.getLog(this.getClass());

    public void buildZip(List<ResultFile> filesList) {
        ArrayList<FileObject> files = new ArrayList<FileObject>();
        for (ResultFile resultFile : filesList) {
            files.add(resultFile.getFile());
        }
        this.buildZipFromFileObjectList(files);
    }

    public void buildZipFromFileObjectList(List<FileObject> files) {
        try {
            this.topFilename = this.getTopFileName(files);
            this.zipName = this.topFilename.getBaseName();
            File tempZip = null;
            if (this.zipName.length() < 3) {
                String tempPrefix = new String();
                for (int i = 0; i < 3 - this.zipName.length(); ++i) {
                    tempPrefix = tempPrefix + "_";
                }
                tempZip = File.createTempFile(tempPrefix + this.zipName, ".tmp");
            } else {
                tempZip = File.createTempFile(this.zipName, ".tmp");
            }
            FileOutputStream fos = new FileOutputStream(tempZip);
            ZipOutputStream zipOut = new ZipOutputStream(fos);
            this.logger.info((Object)("Building '" + this.zipName + "'..."));
            zipOut = this.writeEntriesToZip(files, zipOut);
            zipOut.close();
            fos.close();
            this.setFileInputStream(tempZip);
            this.logger.info((Object)("'" + this.zipName + "' built." + " Sending to client " + this.getZipSize() / 1024 + "KB of data."));
        }
        catch (Exception ex) {
            Logger.getLogger(ZipUtil.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    public void closeInputStream() {
        try {
            this.fis.close();
        }
        catch (IOException ex) {
            Logger.getLogger(ZipUtil.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    private ZipOutputStream writeEntriesToZip(Collection<FileObject> files, ZipOutputStream zipOut) {
        int i = 0;
        try {
            for (FileObject file : files) {
                this.logger.debug((Object)("Files to process:" + files.size()));
                this.logger.debug((Object)("Files processed: " + ++i));
                this.logger.debug((Object)("Files remaining: " + (files.size() - i)));
                this.logger.debug((Object)file.getName().getPath());
                this.fileListing.add(this.removeTopFilenamePathFromString(file.getName().getPath()));
                ZipEntry zip = null;
                if (file.getType() == FileType.FOLDER) {
                    zip = new ZipEntry(this.removeTopFilenamePathFromString(file.getName().getPath() + File.separator + ""));
                    zipOut.putNextEntry(zip);
                    continue;
                }
                zip = new ZipEntry(this.removeTopFilenamePathFromString(file.getName().getPath()));
                zipOut.putNextEntry(zip);
                byte[] bytes = IOUtils.toByteArray((InputStream)file.getContent().getInputStream());
                zipOut.write(bytes);
                zipOut.closeEntry();
            }
        }
        catch (Exception exception) {
            this.logger.error((Object)exception);
        }
        return zipOut;
    }

    public void unzip(File zipFile, File destinationFolder) {
        byte[] buffer = new byte[1024];
        this.setFileInputStream(zipFile);
        ZipInputStream zis = new ZipInputStream(this.fis);
        try {
            ZipEntry entry = zis.getNextEntry();
            while (entry != null) {
                String filename = entry.getName();
                File newFile = null;
                if (entry.isDirectory()) {
                    newFile = new File(destinationFolder.getAbsolutePath() + File.separator + filename + File.separator);
                    newFile.mkdirs();
                    newFile.mkdir();
                } else {
                    newFile = new File(destinationFolder.getAbsolutePath() + File.separator + filename);
                    newFile.createNewFile();
                    FileOutputStream fos = new FileOutputStream(newFile);
                    int len = 0;
                    while ((len = zis.read(buffer)) > 0) {
                        fos.write(buffer, 0, len);
                    }
                    fos.close();
                }
                entry = zis.getNextEntry();
            }
            zis.closeEntry();
            zis.close();
        }
        catch (IOException ex) {
            Logger.getLogger(ZipUtil.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    private void setFileInputStream(File file) {
        try {
            this.fis = file == null ? null : new FileInputStream(file);
        }
        catch (FileNotFoundException ex) {
            Logger.getLogger(ZipUtil.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    public FileInputStream getZipInputStream() {
        return this.fis;
    }

    public String getZipNameToDownload() {
        return this.getZipName().replaceAll(" ", "-") + ".zip";
    }

    public String getZipName() {
        return this.zipName;
    }

    public int getZipSize() {
        try {
            return this.fis.available();
        }
        catch (IOException ex) {
            Logger.getLogger(ZipUtil.class.getName()).log(Level.SEVERE, null, ex);
            return 0;
        }
    }

    private FileName getTopFileName(List<FileObject> files) {
        FileName topFileName = null;
        try {
            if (!files.isEmpty()) {
                topFileName = files.get(0).getParent().getName();
            }
            for (FileObject file : files) {
                this.logger.debug((Object)file.getParent().getName().getPath());
                FileName myFileName = file.getParent().getName();
                if (topFileName.getURI().length() <= myFileName.getURI().length()) continue;
                topFileName = myFileName;
            }
        }
        catch (Exception exception) {
            this.logger.error((Object)exception);
        }
        return topFileName;
    }

    private String removeTopFilenamePathFromString(String path) {
        String filteredPath = null;
        int index = this.topFilename.getParent().getPath().length();
        filteredPath = path.substring(index);
        return filteredPath;
    }
}

