/*
 * Decompiled with CFR 0.152.
 */
package pt.webdetails.cpk.utils;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Map;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class CpkUtils {
    protected static Log logger = LogFactory.getLog(CpkUtils.class);

    public static void setResponseHeaders(HttpServletResponse response, String mimeType) {
        CpkUtils.setResponseHeaders(response, mimeType, 0, null, 0L);
    }

    public static void setResponseHeaders(HttpServletResponse response, String mimeType, String attachmentName) {
        CpkUtils.setResponseHeaders(response, mimeType, 0, attachmentName, 0L);
    }

    public static void setResponseHeaders(HttpServletResponse response, String mimeType, String attachmentName, long attachmentSize) {
        CpkUtils.setResponseHeaders(response, mimeType, 0, attachmentName, attachmentSize);
    }

    public static void setResponseHeaders(HttpServletResponse response, String mimeType, int cacheDuration, String attachmentName, long attachmentSize) {
        if (response == null) {
            logger.warn((Object)"Parameter 'httpresponse' not found!");
            return;
        }
        if (mimeType != null) {
            response.setHeader("Content-Type", mimeType);
        }
        if (attachmentName != null) {
            response.setHeader("content-disposition", "attachment; filename=" + attachmentName);
        }
        if (attachmentSize > 0L) {
            response.setHeader("Content-Length", String.valueOf(attachmentSize));
        }
        if (cacheDuration > 0) {
            response.setHeader("Cache-Control", "max-age=" + cacheDuration);
        } else {
            response.setHeader("Cache-Control", "max-age=0, no-store");
        }
    }

    public static void redirect(HttpServletResponse response, String url) {
        if (response == null) {
            logger.error((Object)"response not found");
            return;
        }
        try {
            response.sendRedirect(url);
        }
        catch (IOException e) {
            logger.error((Object)"could not redirect", (Throwable)e);
        }
    }

    public static Map<String, Object> getRequestParameters(Map<String, Map<String, Object>> bloatedMap) {
        return bloatedMap.get("request");
    }

    public static Map<String, Object> getPathParameters(Map<String, Map<String, Object>> bloatedMa) {
        return bloatedMa.get("path");
    }

    public static OutputStream getResponseOutputStream(HttpServletResponse response) throws IOException {
        return response.getOutputStream();
    }

    public static void send(HttpServletResponse response, InputStream fileInputStream, String mimeTypes, String fileName, boolean sendAsAttachment) {
        Integer contentLength = null;
        try {
            contentLength = fileInputStream.available();
        }
        catch (IOException e) {
            logger.error((Object)"Failed setting attachment size.", (Throwable)e);
        }
        CpkUtils.send(response, fileInputStream, mimeTypes, fileName, sendAsAttachment, contentLength);
    }

    public static void send(HttpServletResponse response, InputStream fileInputStream, String mimeTypes, String fileName, boolean sendAsAttachment, Integer contentLength) {
        if (mimeTypes != null && !mimeTypes.isEmpty()) {
            response.setContentType(mimeTypes);
        }
        String disposition = sendAsAttachment ? "attachment" : "inline";
        String fileParam = fileName != null && !fileName.isEmpty() ? "; filename=" + fileName : "";
        response.setHeader("Content-disposition", disposition + fileParam);
        if (contentLength != null) {
            response.setContentLength(contentLength.intValue());
        }
        try {
            IOUtils.copy((InputStream)fileInputStream, (OutputStream)response.getOutputStream());
            response.getOutputStream().flush();
            fileInputStream.close();
        }
        catch (Exception ex) {
            logger.error((Object)("Failed to copy file to outputstream: " + ex));
        }
    }
}

