/*
 * Decompiled with CFR 0.152.
 */
package pt.webdetails.cpk.elements.impl.kettleoutputs;

import java.io.ByteArrayInputStream;
import java.io.UnsupportedEncodingException;
import pt.webdetails.cpk.elements.impl.KettleResult;
import pt.webdetails.cpk.elements.impl.kettleoutputs.KettleOutput;
import pt.webdetails.cpk.utils.CpkUtils;

public class SingleCellKettleOutput
extends KettleOutput {
    @Override
    public void processResult(KettleResult result) {
        this.logger.debug((Object)"Process Single Cell - print it");
        try {
            if (!result.getRows().isEmpty()) {
                Object cell = result.getRows().get(0).getData()[0];
                byte[] resultContent = cell.toString().getBytes("UTF-8");
                int attachmentSize = resultContent.length;
                ByteArrayInputStream resultInputStream = new ByteArrayInputStream(resultContent);
                String mimeType = this.getConfiguration().getMimeType();
                String defaultAttachmentName = this.getConfiguration().getAttachmentName();
                String attachmentName = defaultAttachmentName != null ? defaultAttachmentName : "singleCell";
                CpkUtils.send(this.getResponse(), resultInputStream, mimeType, attachmentName, this.getConfiguration().getSendResultAsAttachment(), attachmentSize);
            }
        }
        catch (UnsupportedEncodingException ex) {
            this.logger.error((Object)"Unsupported encoding.", (Throwable)ex);
        }
    }
}

