/*
 * Decompiled with CFR 0.152.
 */
package pt.webdetails.cpk.elements.impl.kettleoutputs;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.codehaus.jackson.annotate.JsonIgnore;
import org.codehaus.jackson.annotate.JsonProperty;
import org.pentaho.di.core.row.RowMeta;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.core.row.ValueMetaInterface;

public class RowsJson {
    private ArrayList<Object[]> rows;
    private RowMetaInterface rowsMeta;

    public RowsJson(Collection<Object[]> rows, RowMetaInterface meta) {
        this.init(rows, meta);
    }

    @JsonIgnore
    private void init(Collection<Object[]> rows, RowMetaInterface meta) {
        this.rows = new ArrayList<Object[]>(rows);
        this.rowsMeta = meta != null ? meta : new RowMeta();
    }

    @JsonProperty(value="queryInfo")
    private QueryInfo getQueryInfo() {
        QueryInfo queryInfo = new QueryInfo(this.rows.size());
        return queryInfo;
    }

    @JsonProperty(value="resultset")
    private ArrayList<Object[]> getResultset() {
        return this.rows;
    }

    @JsonProperty(value="metadata")
    private ArrayList<Metadata> getMetadata() {
        ArrayList<Metadata> metadataList = new ArrayList<Metadata>();
        List meta = this.rowsMeta.getValueMetaList();
        int nrColumns = meta.size();
        Metadata metadata = null;
        String type = null;
        String name = null;
        for (int i = 0; i < nrColumns; ++i) {
            type = ((ValueMetaInterface)meta.get(i)).getTypeDesc();
            name = ((ValueMetaInterface)meta.get(i)).getName();
            metadata = new Metadata(i, type, name);
            metadataList.add(metadata);
        }
        return metadataList;
    }

    private class QueryInfo {
        private int rowsCount;

        public QueryInfo(int rowsCount) {
            this.setRowsCount(rowsCount);
        }

        @JsonIgnore
        private void setRowsCount(int count) {
            this.rowsCount = count;
        }

        @JsonProperty(value="totalRows")
        private int getRowsCount() {
            return this.rowsCount;
        }
    }

    private class Metadata {
        private int colIndex;
        private String colType;
        private String colName;

        public Metadata(int index, String type, String name) {
            this.colIndex = index;
            this.colType = type;
            this.colName = name;
        }

        @JsonIgnore
        private void setColIndex(int index) {
            this.colIndex = index;
        }

        @JsonIgnore
        private void setColType(String type) {
            this.colType = type;
        }

        @JsonIgnore
        private void setColName(String name) {
            this.colName = name;
        }

        @JsonProperty(value="colIndex")
        private int getColIndex() {
            return this.colIndex;
        }

        @JsonProperty(value="colType")
        private String getColType() {
            return this.colType;
        }

        @JsonProperty(value="colName")
        private String getColName() {
            return this.colName;
        }
    }
}

