/*
 * Decompiled with CFR 0.152.
 */
package pt.webdetails.cpk.elements.impl.kettleoutputs;

import java.io.InputStream;
import java.util.ArrayList;
import org.apache.commons.vfs.FileName;
import org.apache.commons.vfs.FileObject;
import org.apache.commons.vfs.FileSystemException;
import org.apache.commons.vfs.FileType;
import org.pentaho.di.core.ResultFile;
import org.pentaho.di.core.vfs.KettleVFS;
import pt.webdetails.cpf.utils.MimeTypes;
import pt.webdetails.cpk.elements.impl.KettleResult;
import pt.webdetails.cpk.elements.impl.kettleoutputs.KettleOutput;
import pt.webdetails.cpk.utils.CpkUtils;
import pt.webdetails.cpk.utils.ZipUtil;

public class ResultFilesKettleOutput
extends KettleOutput {
    @Override
    public void processResult(KettleResult result) {
        this.logger.debug((Object)"Process Result Files");
        ArrayList<FileObject> files = new ArrayList<FileObject>();
        for (ResultFile resultFile : result.getFiles()) {
            files.add(resultFile.getFile());
        }
        if (files.isEmpty()) {
            this.logger.warn((Object)"Processing result files but no files found");
            this.getResponse().setStatus(204);
            return;
        }
        String defaultAttachmentName = this.getConfiguration().getAttachmentName();
        try {
            if (files.size() == 1 && ((FileObject)files.get(0)).getType() == FileType.FILE) {
                FileObject file = (FileObject)files.get(0);
                InputStream fileInputStream = KettleVFS.getInputStream((FileObject)file);
                FileName fileName = file.getName();
                String defaultMimeType = this.getConfiguration().getMimeType();
                String mimeType = defaultMimeType != null ? defaultMimeType : MimeTypes.getMimeType((String)fileName.getBaseName());
                String attachmentName = defaultAttachmentName != null ? defaultAttachmentName : fileName.getBaseName();
                CpkUtils.send(this.getResponse(), fileInputStream, mimeType, attachmentName, this.getConfiguration().getSendResultAsAttachment());
            } else {
                ZipUtil zip = new ZipUtil();
                zip.buildZipFromFileObjectList(files);
                String attachmentName = defaultAttachmentName != null ? defaultAttachmentName : zip.getZipNameToDownload();
                CpkUtils.send(this.getResponse(), zip.getZipInputStream(), "application/zip", attachmentName, true);
            }
        }
        catch (FileSystemException ex) {
            this.logger.error((Object)"Failed sending files from kettle result.", (Throwable)ex);
        }
    }
}

