/*
 * Decompiled with CFR 0.152.
 */
package pt.webdetails.cpk.elements.impl.kettleoutputs;

import java.io.IOException;
import java.io.OutputStream;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import pt.webdetails.cpk.elements.impl.kettleoutputs.IKettleOutput;

public abstract class KettleOutput
implements IKettleOutput {
    protected Log logger = LogFactory.getLog(this.getClass());
    protected final String ENCODING = "UTF-8";
    private OutputStream out;
    private HttpServletResponse response;
    private Configuration configuration;

    protected OutputStream getOut() {
        return this.out;
    }

    public HttpServletResponse getResponse() {
        return this.response;
    }

    public KettleOutput setResponse(HttpServletResponse response) {
        this.response = response;
        try {
            this.out = response.getOutputStream();
        }
        catch (IOException ex) {
            this.logger.error((Object)"Something went wrong setting http response on KettleOutput.", (Throwable)ex);
        }
        return this;
    }

    public Configuration getConfiguration() {
        return this.configuration;
    }

    public KettleOutput setConfiguration(Configuration configuration) {
        this.configuration = configuration;
        return this;
    }

    public static final class Configuration
    implements Cloneable {
        private String outputType;
        private String mimeType;
        private String attachmentName;
        private boolean sendResultAsAttachment = false;

        public String getOutputType() {
            return this.outputType;
        }

        public Configuration setOutputType(String outputType) {
            this.outputType = outputType;
            return this;
        }

        public boolean getSendResultAsAttachment() {
            return this.sendResultAsAttachment;
        }

        public Configuration setSendResultAsAttachment(boolean sendResultAsAttachment) {
            this.sendResultAsAttachment = sendResultAsAttachment;
            return this;
        }

        public String getAttachmentName() {
            return this.attachmentName;
        }

        public Configuration setAttachmentName(String attachmentName) {
            this.attachmentName = attachmentName;
            return this;
        }

        public String getMimeType() {
            return this.mimeType;
        }

        public Configuration setMimeType(String mimeType) {
            this.mimeType = mimeType;
            return this;
        }

        public Configuration clone() {
            Configuration clone = new Configuration();
            clone.setAttachmentName(this.attachmentName).setMimeType(this.mimeType).setSendResultAsAttachment(this.sendResultAsAttachment).setOutputType(this.outputType);
            return clone;
        }
    }
}

