/*
 * Decompiled with CFR 0.152.
 */
package pt.webdetails.cpk.elements.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.pentaho.di.core.Result;
import org.pentaho.di.core.RowMetaAndData;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.exception.KettleStepException;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.trans.Trans;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.RowAdapter;
import org.pentaho.di.trans.step.RowListener;
import org.pentaho.di.trans.step.StepInterface;
import org.pentaho.di.trans.step.StepMeta;
import pt.webdetails.cpk.datasources.DataSource;
import pt.webdetails.cpk.datasources.DataSourceMetadata;
import pt.webdetails.cpk.datasources.KettleElementDefinition;
import pt.webdetails.cpk.datasources.KettleElementMetadata;
import pt.webdetails.cpk.elements.IDataSourceProvider;
import pt.webdetails.cpk.elements.impl.KettleElement;
import pt.webdetails.cpk.elements.impl.KettleElementHelper;
import pt.webdetails.cpk.elements.impl.KettleResult;

public class KettleTransformationElement
extends KettleElement<TransMeta>
implements IDataSourceProvider {
    @Override
    protected TransMeta loadMeta(String filePath) {
        try {
            return new TransMeta(this.getLocation());
        }
        catch (Exception e) {
            return null;
        }
    }

    protected DataSourceMetadata getMetadata() {
        List steps = ((TransMeta)this.meta).getSteps();
        ArrayList<String> stepNames = new ArrayList<String>();
        for (StepMeta step : steps) {
            stepNames.add(step.getName());
        }
        return new KettleElementMetadata().setKettleStepNames(Collections.unmodifiableCollection(stepNames)).setEndpointName(this.getName());
    }

    @Override
    public DataSource getDataSource() {
        DataSource dataSource = new DataSource();
        dataSource.setDefinition(new KettleElementDefinition()).setMetadata(this.getMetadata());
        return dataSource;
    }

    @Override
    protected KettleResult processRequest(Map<String, String> kettleParameters, String outputStepName) {
        this.logger.info((Object)("Starting transformation '" + this.getName() + "' (" + ((TransMeta)this.meta).getName() + ")"));
        long start = System.currentTimeMillis();
        KettleResult result = null;
        final ArrayList rows = new ArrayList();
        try {
            ((TransMeta)this.meta).setResultRows(new ArrayList());
            ((TransMeta)this.meta).setResultFiles(new ArrayList());
            List<String> setParameters = Collections.emptyList();
            if (kettleParameters != null) {
                setParameters = KettleElementHelper.setKettleParameterValues(this.meta, kettleParameters);
            }
            Trans transformation = new Trans((TransMeta)this.meta);
            transformation.prepareExecution(null);
            StepInterface step = this.getRunThread(transformation, outputStepName);
            if (step != null) {
                step.addRowListener((RowListener)new RowAdapter(){

                    public void rowWrittenEvent(RowMetaInterface rowMeta, Object[] data) throws KettleStepException {
                        rows.add(new RowMetaAndData(rowMeta, data));
                    }
                });
            } else {
                this.logger.error((Object)("Couldn't find step '" + outputStepName + "' nor default output step '" + this.getDefaultOutputName() + "'."));
            }
            transformation.startThreads();
            transformation.waitUntilFinished();
            Result transformationResult = transformation.getResult();
            transformationResult.setRows(rows);
            result = new KettleResult(transformationResult);
            result.setKettleType(KettleResult.KettleType.TRANSFORMATION);
            KettleElementHelper.clearParameters(this.meta, setParameters);
        }
        catch (KettleException e) {
            this.logger.debug((Object)("KETTLE EXCEPTION: " + (Object)((Object)e)), (Throwable)e);
        }
        long end = System.currentTimeMillis();
        this.logger.info((Object)("Finished transformation '" + this.getName() + "' (" + ((TransMeta)this.meta).getName() + ") in " + (end - start) + " ms"));
        return result;
    }

    protected StepInterface getRunThread(Trans transformation, String stepName) {
        Collection<String> outputStepNames = this.getOutputNames();
        StepInterface step = outputStepNames.contains(stepName) ? transformation.findRunThread(stepName) : transformation.findRunThread(this.getDefaultOutputName());
        return step;
    }

    @Override
    protected Collection<String> getOutputNames() {
        ArrayList<String> validOutputStepNames = new ArrayList<String>();
        for (String name : ((TransMeta)this.meta).getStepNames()) {
            if (!this.isValidOutputName(name)) continue;
            validOutputStepNames.add(name);
        }
        return validOutputStepNames;
    }
}

