/*
 * Decompiled with CFR 0.152.
 */
package pt.webdetails.cpk.elements.impl;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Collections;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.pentaho.di.core.Result;
import org.pentaho.di.core.ResultFile;
import org.pentaho.di.core.RowMetaAndData;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.xml.XMLHandler;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public final class KettleResult
implements Serializable {
    private static final long serialVersionUID = 110982374129L;
    protected transient Log logger = LogFactory.getLog(this.getClass());
    private transient Result result;
    private KettleType kettleType;

    public boolean wasExecutedSuccessfully() {
        return this.result.getResult();
    }

    public int getExitStatus() {
        return this.result.getExitStatus();
    }

    public long getNumberOfErrors() {
        return this.result.getNrErrors();
    }

    public List<ResultFile> getFiles() {
        return this.result.getResultFilesList();
    }

    public List<RowMetaAndData> getRows() {
        if (this.result.getRows() == null) {
            return Collections.emptyList();
        }
        return this.result.getRows();
    }

    public KettleType getKettleType() {
        return this.kettleType;
    }

    public KettleResult setKettleType(KettleType kettleType) {
        this.kettleType = kettleType;
        return this;
    }

    public KettleResult(Result result) {
        this.result = result;
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
        String resultXmlString = this.result.getXML();
        out.writeUTF(resultXmlString);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        String resultXmlString = in.readUTF();
        try {
            Document document = XMLHandler.loadXMLString((String)resultXmlString);
            Node resultNode = XMLHandler.getSubNode((Node)document, (String)"result");
            this.result = new Result(resultNode);
        }
        catch (KettleException e) {
            this.logger.error((Object)"Unable to deserialize KettleResult.", (Throwable)e);
        }
    }

    public static enum KettleType {
        JOB,
        TRANSFORMATION;

    }
}

