/*
 * Decompiled with CFR 0.152.
 */
package pt.webdetails.cpk.elements.impl;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.pentaho.di.core.Result;
import org.pentaho.di.job.Job;
import org.pentaho.di.job.JobMeta;
import pt.webdetails.cpk.datasources.DataSource;
import pt.webdetails.cpk.datasources.DataSourceMetadata;
import pt.webdetails.cpk.datasources.KettleElementDefinition;
import pt.webdetails.cpk.datasources.KettleElementMetadata;
import pt.webdetails.cpk.elements.IDataSourceProvider;
import pt.webdetails.cpk.elements.impl.KettleElement;
import pt.webdetails.cpk.elements.impl.KettleElementHelper;
import pt.webdetails.cpk.elements.impl.KettleResult;

public class KettleJobElement
extends KettleElement<JobMeta>
implements IDataSourceProvider {
    @Override
    protected JobMeta loadMeta(String filePath) {
        try {
            return new JobMeta(this.getLocation(), null);
        }
        catch (Exception e) {
            return null;
        }
    }

    protected DataSourceMetadata getMetadata() {
        return new KettleElementMetadata().setEndpointName(this.getName());
    }

    @Override
    public DataSource getDataSource() {
        return new DataSource().setMetadata(this.getMetadata()).setDefinition(new KettleElementDefinition());
    }

    private Result getResult(Job job) {
        return job.getResult();
    }

    @Override
    protected Collection<String> getOutputNames() {
        return Collections.emptyList();
    }

    @Override
    public KettleResult processRequest(Map<String, String> kettleParameters, String outputJobEntryName) {
        this.logger.info((Object)("Starting job '" + this.getName() + "' (" + ((JobMeta)this.meta).getName() + ")"));
        long start = System.currentTimeMillis();
        List<String> setParameters = Collections.emptyList();
        if (kettleParameters != null) {
            setParameters = KettleElementHelper.setKettleParameterValues(this.meta, kettleParameters);
        }
        Job job = new Job(null, (JobMeta)this.meta);
        job.start();
        job.waitUntilFinished();
        Result jobResult = this.getResult(job);
        KettleResult result = new KettleResult(jobResult);
        result.setKettleType(KettleResult.KettleType.JOB);
        KettleElementHelper.clearParameters(this.meta, setParameters);
        long end = System.currentTimeMillis();
        this.logger.info((Object)("Finished job '" + this.getName() + "' (" + ((JobMeta)this.meta).getName() + ") in " + (end - start) + " ms"));
        return result;
    }
}

