/*
 * Decompiled with CFR 0.152.
 */
package pt.webdetails.cpk.datasources;

import org.codehaus.jackson.annotate.JsonProperty;
import pt.webdetails.cpk.datasources.DataSourceMetadata;

public class CpkDataSourceMetadata
extends DataSourceMetadata {
    private String endpointName;

    public CpkDataSourceMetadata() {
        this.setDataType("cpk");
    }

    public CpkDataSourceMetadata(String pluginId, String endpointName) {
        this();
        this.setPluginId(pluginId).setEndpointName(endpointName);
    }

    @Override
    public CpkDataSourceMetadata setPluginId(String pluginId) {
        super.setPluginId(pluginId);
        this.setGroup(String.format("%s_CPKENDPOINTS", pluginId.toUpperCase())).setGroupDescription(String.format("%s Endpoints", pluginId.toUpperCase()));
        return this;
    }

    @JsonProperty(value="endpoint")
    public String getEndpointName() {
        return this.endpointName;
    }

    public CpkDataSourceMetadata setEndpointName(String endpointName) {
        this.endpointName = endpointName;
        this.setName(String.format("%s Endpoint", endpointName));
        return this;
    }
}

