/*
 * Decompiled with CFR 0.152.
 */
package pt.webdetails.cpk.cache;

import java.io.Serializable;
import net.sf.ehcache.Cache;
import net.sf.ehcache.CacheManager;
import net.sf.ehcache.Element;
import net.sf.ehcache.config.CacheConfiguration;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import pt.webdetails.cpk.cache.ICache;

public class EHCache<K extends Serializable, V extends Serializable>
implements ICache<K, V> {
    private static final Log logger = LogFactory.getLog(EHCache.class);
    private Cache cache = null;

    public Cache getCache() {
        return this.cache;
    }

    private synchronized CacheManager getCacheManager() {
        return CacheManager.create();
    }

    public EHCache(CacheConfiguration cacheConfiguration) {
        Cache cache = this.getCacheManager().getCache(cacheConfiguration.getName());
        if (cache == null) {
            cache = new Cache(cacheConfiguration);
            this.getCacheManager().addCache(cache);
        }
        this.cache = cache;
    }

    @Override
    public void put(K key, V value) {
        Element storeElement = new Element(key, value);
        this.cache.put(storeElement);
        logger.debug((Object)("Cache status: " + this.cache.getMemoryStoreSize() + " in memory, " + this.cache.getDiskStoreSize() + " in disk"));
    }

    @Override
    public void put(K key, V value, int timeToLiveSeconds) {
        Element storeElement = new Element(key, value);
        storeElement.setTimeToLive(timeToLiveSeconds);
        if (timeToLiveSeconds == 0) {
            storeElement.setTimeToIdle(0);
        }
        this.cache.put(storeElement);
        logger.debug((Object)("Cache status: " + this.cache.getMemoryStoreSize() + " in memory, " + this.cache.getDiskStoreSize() + " in disk"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public V get(K key) {
        V v;
        ClassLoader contextCL = Thread.currentThread().getContextClassLoader();
        try {
            Serializable value;
            Thread.currentThread().setContextClassLoader(this.getClass().getClassLoader());
            Element element = this.cache.get(key);
            if (element != null && (value = (Serializable)element.getObjectValue()) != null) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)"Found value in cache. Returning");
                    logger.debug((Object)("Cache status: " + this.cache.getMemoryStoreSize() + " in memory, " + this.cache.getDiskStoreSize() + " in disk"));
                }
                Serializable serializable = value;
                return (V)serializable;
            }
            v = null;
            return v;
        }
        catch (Exception e) {
            logger.error((Object)("Error while attempting to load from cache, bypassing cache (cause: " + e.getClass() + ")"), (Throwable)e);
            v = null;
            return v;
        }
        finally {
            Thread.currentThread().setContextClassLoader(contextCL);
        }
    }

    @Override
    public Iterable<K> getKeys() {
        return this.cache.getKeys();
    }

    @Override
    public boolean remove(K key) {
        return this.getCache().remove(key);
    }

    @Override
    public void clear() {
        this.cache.removeAll();
        logger.info((Object)("Cache " + this.cache.getName() + " was cleared."));
    }

    @Override
    public Number getTimeToLiveSeconds() {
        return this.getCache().getCacheConfiguration().getTimeToLiveSeconds();
    }
}

