/*
 * Decompiled with CFR 0.152.
 */
package pt.webdetails.cpk;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import net.sf.ehcache.config.CacheConfiguration;
import net.sf.ehcache.config.Configuration;
import net.sf.ehcache.config.ConfigurationFactory;
import net.sf.ehcache.store.MemoryStoreEvictionPolicy;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Node;
import org.dom4j.io.SAXReader;
import pt.webdetails.cpk.ICpkEnvironment;
import pt.webdetails.cpk.Status;
import pt.webdetails.cpk.cache.EHCache;
import pt.webdetails.cpk.cache.ICache;
import pt.webdetails.cpk.elements.Element;
import pt.webdetails.cpk.elements.IDataSourceProvider;
import pt.webdetails.cpk.elements.IElement;
import pt.webdetails.cpk.elements.impl.KettleResult;
import pt.webdetails.cpk.elements.impl.KettleResultKey;

public class CpkEngine {
    private static Log logger = LogFactory.getLog(CpkEngine.class);
    private static final String DEFAULT_SETTINGS_FILENAME = "cpk.xml";
    private static final String DEFAULT_CACHE_SETTINGS_FILENAME = "ehcache.xml";
    private ICpkEnvironment environment;
    private String settingsFilename;
    private TreeMap<String, IElement> elementsMap = new TreeMap();
    private IElement defaultElement;
    private ICache<KettleResultKey, KettleResult> kettleResultCache;

    private String getDefaultCacheName() {
        return CpkEngine.class.getPackage().getName() + ":" + this.getEnvironment().getPluginName();
    }

    private CacheConfiguration getDefaultCacheConfiguration() {
        CacheConfiguration cacheConfiguration = new CacheConfiguration();
        cacheConfiguration.setName(this.getDefaultCacheName());
        cacheConfiguration.setMaxEntriesLocalHeap(100L);
        cacheConfiguration.setMaxEntriesLocalDisk(10000L);
        cacheConfiguration.setTimeToIdleSeconds(0L);
        cacheConfiguration.setTimeToLiveSeconds(0L);
        cacheConfiguration.overflowToDisk(true);
        cacheConfiguration.diskPersistent(false);
        cacheConfiguration.setDiskExpiryThreadIntervalSeconds(360L);
        cacheConfiguration.diskSpoolBufferSizeMB(50);
        cacheConfiguration.setMemoryStoreEvictionPolicyFromObject(MemoryStoreEvictionPolicy.LFU);
        return cacheConfiguration;
    }

    public ICache<KettleResultKey, KettleResult> getKettleResultCache() {
        return this.kettleResultCache;
    }

    private CpkEngine() {
    }

    public static CpkEngine getInstance() {
        return CpkEngineHolder.INSTANCE;
    }

    public synchronized void init(ICpkEnvironment environment) {
        if (environment == null) {
            logger.fatal((Object)"Failed to initialize CPK Plugin: null environment");
            return;
        }
        if (this.environment != null) {
            logger.warn((Object)("CPK Plugin '" + this.environment.getPluginName() + "' was already initialized"));
            return;
        }
        this.environment = environment;
        this.settingsFilename = DEFAULT_SETTINGS_FILENAME;
        this.initializeKettleResultCache();
        this.reload();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void initializeKettleResultCache() {
        CacheConfiguration cacheConfiguration;
        InputStream configFile = null;
        try {
            configFile = this.getEnvironment().getContentAccessFactory().getPluginSystemReader("").getFileInputStream(DEFAULT_CACHE_SETTINGS_FILENAME);
            Configuration cacheManagerConfiguration = ConfigurationFactory.parseConfiguration((InputStream)configFile);
            Collection cacheConfigurations = cacheManagerConfiguration.getCacheConfigurations().values();
            cacheConfiguration = (CacheConfiguration)cacheConfigurations.iterator().next();
            if (cacheConfiguration.getName() == null || cacheConfiguration.getName().isEmpty()) {
                cacheConfiguration.setName(this.getDefaultCacheName());
            }
            logger.debug((Object)(this.getEnvironment().getPluginName() + " is using cache configuration from file " + DEFAULT_CACHE_SETTINGS_FILENAME));
        }
        catch (Exception ioe) {
            try {
                logger.info((Object)"No Eh cache configuration file found ehcache.xml.");
                cacheConfiguration = this.getDefaultCacheConfiguration();
                logger.info((Object)(this.getEnvironment().getPluginName() + " is using default hardcoded cache configuration."));
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(configFile);
                throw throwable;
            }
            IOUtils.closeQuietly((InputStream)configFile);
        }
        IOUtils.closeQuietly((InputStream)configFile);
        this.kettleResultCache = new EHCache<KettleResultKey, KettleResult>(cacheConfiguration);
        this.reload();
    }

    public void reload() {
        logger.info((Object)("Initializing CPK Plugin '" + this.environment.getPluginName() + "'"));
        long start = System.currentTimeMillis();
        this.environment.reload();
        this.loadElements();
        if (this.getKettleResultCache() != null) {
            this.getKettleResultCache().clear();
        }
        long end = System.currentTimeMillis();
        logger.info((Object)("Finished initialization of CPK PLugin '" + this.environment.getPluginName() + "' in " + (end - start) + " ms"));
    }

    public ICpkEnvironment getEnvironment() {
        return this.environment;
    }

    public IElement getElement(String elementId) {
        logger.debug((Object)("Getting element '" + elementId + "'"));
        return this.elementsMap.get(elementId);
    }

    public Collection<IElement> getElements() {
        logger.debug((Object)"Getting read-only collection of elements");
        return Collections.unmodifiableCollection(this.elementsMap.values());
    }

    public Map<String, IElement> getElementsMap() {
        logger.debug((Object)"Getting read-only map of elements");
        return Collections.unmodifiableMap(this.elementsMap);
    }

    public IElement getDefaultElement() {
        logger.debug((Object)("Getting default element '" + this.defaultElement.getName() + "'"));
        return this.defaultElement;
    }

    public Status getStatus() {
        if (this.defaultElement != null) {
            return new Status(this.elementsMap, this.defaultElement.getName(), this.environment);
        }
        return new Status(this.elementsMap, "", this.environment);
    }

    private void loadElements() {
        try {
            InputStream is = this.environment.getContentAccessFactory().getPluginSystemReader(null).getFileInputStream(this.settingsFilename);
            SAXReader reader = new SAXReader();
            Document doc = reader.read(is);
            this.elementsMap.clear();
            List elementTypeNodes = doc.selectNodes("/cpk/elementTypes/elementType");
            for (Object elementTypeNode : elementTypeNodes) {
                Node type = (Node)elementTypeNode;
                String typeName = type.valueOf("./@name");
                String typeClass = type.valueOf("./@class");
                logger.info((Object)("Loading '" + typeName + "' elements [" + typeClass + "]"));
                List elementLocations = type.selectNodes("elementLocations/elementLocation");
                for (Object elementLocation : elementLocations) {
                    Node location = (Node)elementLocation;
                    String path = location.valueOf("@path");
                    Boolean isRecursive = Boolean.parseBoolean(location.valueOf("@isRecursive"));
                    String pattern = location.valueOf("@pattern");
                    Boolean adminOnly = Boolean.parseBoolean(location.valueOf("@adminOnly"));
                    Collection files = this.environment.getPluginUtils().getPluginResources(path, isRecursive, pattern);
                    if (files == null) continue;
                    for (File file : files) {
                        this.loadElement(typeName, typeClass, file.getAbsolutePath(), adminOnly);
                    }
                }
            }
            this.defaultElement = this.findDefaultElement(doc.selectSingleNode("/cpk/elementTypes").valueOf("@defaultElement").toLowerCase());
            is.close();
        }
        catch (IOException e) {
            logger.error((Object)("Failed to open settings file '" + this.settingsFilename + "'"));
        }
        catch (DocumentException e) {
            logger.error((Object)("Failed to parse settings file '" + this.settingsFilename + "'"));
        }
    }

    private void loadElement(String type, String typeClass, String filePath, boolean adminOnly) {
        String id = FilenameUtils.getBaseName((String)filePath).toLowerCase();
        if (id.startsWith("_")) {
            logger.debug((Object)("Skipped element '" + filePath + "'"));
            return;
        }
        logger.info((Object)("Loading element '" + filePath + "'"));
        if (this.elementsMap.containsKey(id)) {
            logger.warn((Object)("Failed: an element '" + id + "' already exists"));
            return;
        }
        if (this.environment.getReservedWords().contains(id)) {
            logger.warn((Object)("Failed: '" + id + "' is a reserved word"));
            return;
        }
        try {
            Element element = (Element)Class.forName(typeClass).newInstance();
            String pluginId = this.getEnvironment().getPluginName();
            if (element.init(pluginId, id, type, filePath, adminOnly)) {
                this.elementsMap.put(id, element);
                logger.info((Object)("Done " + element.toString()));
            }
            if (element instanceof IDataSourceProvider) {
                ((IDataSourceProvider)((Object)element)).setCache(this.getKettleResultCache());
            }
        }
        catch (Exception e) {
            logger.error((Object)("Failed: missing '" + typeClass + "'"));
        }
    }

    private IElement findDefaultElement(String defaultElementId) {
        if (this.elementsMap.containsKey(defaultElementId)) {
            logger.info((Object)("Found default element '" + defaultElementId + "'"));
            return this.elementsMap.get(defaultElementId);
        }
        logger.info((Object)("Didn't find default element '" + defaultElementId + "'"));
        for (IElement element : this.elementsMap.values()) {
            if (!element.isRenderable()) continue;
            logger.info((Object)("Will use '" + element.getId() + "' as default element"));
            return element;
        }
        logger.error((Object)"There isn't a default element");
        return null;
    }

    private static class CpkEngineHolder {
        public static final CpkEngine INSTANCE = new CpkEngine();

        private CpkEngineHolder() {
        }
    }
}

