/*
 * Decompiled with CFR 0.152.
 */
package pt.webdetails.cpf.repository.vfs;

import java.util.ArrayList;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.commons.vfs.FileObject;
import org.apache.commons.vfs.FileSystemException;
import org.apache.commons.vfs.FileType;
import org.apache.commons.vfs.FileUtil;
import pt.webdetails.cpf.repository.IRepositoryFile;
import pt.webdetails.cpf.repository.IRepositoryFileFilter;

public class VfsRepositoryFile
implements IRepositoryFile {
    protected static final Log log = LogFactory.getLog(VfsRepositoryFile.class);
    private FileObject repo;
    private FileObject file;

    public VfsRepositoryFile(FileObject repo, FileObject file) {
        this.repo = repo;
        this.file = file;
    }

    @Override
    public boolean isDirectory() {
        try {
            return FileType.FOLDER.equals(this.file.getType());
        }
        catch (FileSystemException e) {
            throw new RuntimeException("Error accessing repository file: " + this.file, e);
        }
    }

    @Override
    public String getFileName() {
        try {
            String filename = this.file.getName().getBaseName();
            return filename;
        }
        catch (Exception e) {
            throw new RuntimeException("Error accessing repository file: " + this.file, e);
        }
    }

    @Override
    public String getSolutionPath() {
        try {
            String relativePath = this.repo.getName().getRelativeName(this.file.getName());
            return relativePath;
        }
        catch (Exception e) {
            throw new RuntimeException("Error accessing repository file: " + this.file, e);
        }
    }

    @Override
    public String getSolution() {
        throw new UnsupportedOperationException("getSolution is deprecated, not supported!");
    }

    @Override
    public String getFullPath() {
        try {
            String path = this.repo.getName().getPath();
            return path;
        }
        catch (Exception e) {
            throw new RuntimeException("Error accessing repository file: " + this.file, e);
        }
    }

    @Override
    public IRepositoryFile[] listFiles() {
        try {
            FileObject[] children;
            if (this.isDirectory() && (children = this.file.getChildren()) != null) {
                IRepositoryFile[] files = new IRepositoryFile[children.length];
                for (int i = 0; i < children.length; ++i) {
                    files[i] = new VfsRepositoryFile(this.repo, children[i]);
                }
                return files;
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Error accessing repository file: " + this.file, e);
        }
        return new IRepositoryFile[0];
    }

    @Override
    public IRepositoryFile[] listFiles(IRepositoryFileFilter iff) {
        ArrayList<IRepositoryFile> fileList = new ArrayList<IRepositoryFile>();
        IRepositoryFile[] files = this.listFiles();
        if (iff == null) {
            return files;
        }
        if (files != null) {
            for (IRepositoryFile f : files) {
                if (!iff.accept(f)) continue;
                fileList.add(f);
            }
            return fileList.toArray(new IRepositoryFile[fileList.size()]);
        }
        return new IRepositoryFile[0];
    }

    @Override
    public boolean isRoot() {
        return this.repo.getName().equals(this.file.getName());
    }

    @Override
    public IRepositoryFile retrieveParent() {
        try {
            if (this.file.getParent().equals(this.repo) || this.getSolutionPath().startsWith("..")) {
                return null;
            }
            return new VfsRepositoryFile(this.repo, this.file.getParent());
        }
        catch (Exception e) {
            throw new RuntimeException("Error accessing retrieveParent: " + this.file, e);
        }
    }

    @Override
    public byte[] getData() {
        try {
            return FileUtil.getContent((FileObject)this.file);
        }
        catch (Exception e) {
            throw new RuntimeException("Error reading file: " + this.file, e);
        }
    }

    @Override
    public boolean exists() {
        try {
            return this.file.exists();
        }
        catch (Exception e) {
            throw new RuntimeException("Error accessing exists: " + this.file, e);
        }
    }

    @Override
    public long getLastModified() {
        try {
            return this.file.getContent().getLastModifiedTime();
        }
        catch (Exception e) {
            throw new RuntimeException("Error accessing getLastModified: " + this.file, e);
        }
    }

    @Override
    public String getExtension() {
        try {
            return this.file.getName().getExtension();
        }
        catch (Exception e) {
            throw new RuntimeException("Error accessing getExtension: " + this.file, e);
        }
    }
}

