/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.telemetry;

import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.util.concurrent.BlockingQueue;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.pentaho.telemetry.TelemetryEvent;

public class TelemetryEventKeeper
implements Runnable {
    private static final Log logger = LogFactory.getLog(TelemetryEventKeeper.class);
    private String requestPath;
    private BlockingQueue<TelemetryEvent> queue;

    public TelemetryEventKeeper(BlockingQueue<TelemetryEvent> queue, String requestPath) {
        this.requestPath = requestPath;
        this.queue = queue;
    }

    @Override
    public void run() {
        try {
            while (true) {
                this.process();
            }
        }
        catch (InterruptedException ie) {
            logger.warn((Object)"Got interrupted. Exiting.");
            return;
        }
    }

    public void process() throws InterruptedException {
        TelemetryEvent event = this.queue.take();
        try {
            FileOutputStream fout = new FileOutputStream(this.requestPath + "/" + System.currentTimeMillis() + ".tel");
            ObjectOutputStream oos = new ObjectOutputStream(fout);
            oos.writeObject(event);
            oos.close();
        }
        catch (FileNotFoundException fnfe) {
            logger.warn((Object)"Unable to create file for telemetry event", (Throwable)fnfe);
        }
        catch (IOException ioe) {
            logger.error((Object)"Error caught while creating file for telemetry event", (Throwable)ioe);
        }
    }
}

