/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.marketplace.domain.services;

import java.io.File;
import java.io.FileReader;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.StringReader;
import java.lang.reflect.Method;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.apache.commons.io.filefilter.DirectoryFileFilter;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.pentaho.di.core.Result;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.logging.LogLevel;
import org.pentaho.di.core.parameters.NamedParams;
import org.pentaho.di.job.Job;
import org.pentaho.di.job.JobMeta;
import org.pentaho.marketplace.domain.model.entities.DevelopmentStage;
import org.pentaho.marketplace.domain.model.entities.interfaces.ICategory;
import org.pentaho.marketplace.domain.model.entities.interfaces.IDevelopmentStage;
import org.pentaho.marketplace.domain.model.entities.interfaces.IDomainStatusMessage;
import org.pentaho.marketplace.domain.model.entities.interfaces.IPlugin;
import org.pentaho.marketplace.domain.model.entities.interfaces.IPluginVersion;
import org.pentaho.marketplace.domain.model.entities.interfaces.IVersionData;
import org.pentaho.marketplace.domain.model.factories.interfaces.ICategoryFactory;
import org.pentaho.marketplace.domain.model.factories.interfaces.IDomainStatusMessageFactory;
import org.pentaho.marketplace.domain.model.factories.interfaces.IPluginFactory;
import org.pentaho.marketplace.domain.model.factories.interfaces.IPluginVersionFactory;
import org.pentaho.marketplace.domain.model.factories.interfaces.IVersionDataFactory;
import org.pentaho.marketplace.domain.services.helpers.Util;
import org.pentaho.marketplace.domain.services.interfaces.IPluginService;
import org.pentaho.platform.api.engine.IPentahoSession;
import org.pentaho.platform.api.engine.IPluginManager;
import org.pentaho.platform.api.engine.IPluginResourceLoader;
import org.pentaho.platform.engine.core.system.PentahoSessionHolder;
import org.pentaho.platform.engine.core.system.PentahoSystem;
import org.pentaho.platform.engine.security.SecurityHelper;
import org.pentaho.platform.util.VersionHelper;
import org.pentaho.platform.util.VersionInfo;
import org.pentaho.platform.util.web.HttpUtil;
import org.pentaho.telemetry.BaPluginTelemetry;
import org.pentaho.telemetry.TelemetryHelper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.Authentication;
import org.springframework.security.GrantedAuthority;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public class PluginService
implements IPluginService {
    private static final String UNAUTHORIZED_ACCESS_MESSAGE = "Unauthorized Access. Your Pentaho roles do not allow you to make changes to plugins.";
    private static final String UNAUTHORIZED_ACCESS_ERROR_CODE = "ERROR_0002_UNAUTHORIZED_ACCESS";
    private static final String NO_PLUGIN_ERROR_CODE = "ERROR_0001_NO_PLUGIN";
    private static final String FAIL_ERROR_CODE = "ERROR_0003_FAIL";
    private static final String PLUGIN_INSTALLED_CODE = "PLUGIN_INSTALLED";
    private static final String PLUGIN_UNINSTALLED_CODE = "PLUGIN_UNINSTALLED";
    private static final String CLOSE_METHOD_NAME = "close";
    private static final String PLUGIN_NAME = "marketplace";
    private static final String MARKETPLACE_ENTRIES_URL_FALLBACK = "https://raw.github.com/pentaho/marketplace-metadata/master/marketplace.xml";
    private Log logger = LogFactory.getLog(this.getClass());
    private XPath xpath;
    private IPluginFactory pluginFactory;
    private IPluginVersionFactory pluginVersionFactory;
    private IVersionDataFactory versionDataFactory;
    private ICategoryFactory categoryFactory;
    private IDomainStatusMessageFactory domainStatusMessageFactory;

    @Autowired
    public PluginService(IPluginFactory pluginFactory, IPluginVersionFactory pluginVersionFactory, IVersionDataFactory versionDataFactory, ICategoryFactory categoryFactory, IDomainStatusMessageFactory domainStatusMessageFactory) {
        this.pluginFactory = pluginFactory;
        this.pluginVersionFactory = pluginVersionFactory;
        this.versionDataFactory = versionDataFactory;
        this.categoryFactory = categoryFactory;
        this.domainStatusMessageFactory = domainStatusMessageFactory;
        this.xpath = XPathFactory.newInstance().newXPath();
    }

    private void closeClassLoader(String pluginId) {
        IPluginManager pluginManager = (IPluginManager)PentahoSystem.get(IPluginManager.class, (IPentahoSession)PentahoSessionHolder.getSession());
        ClassLoader cl = pluginManager.getClassLoader(pluginId);
        if (cl != null && cl instanceof URLClassLoader) {
            try {
                URLClassLoader cl1 = (URLClassLoader)cl;
                Util.closeURLClassLoader(cl1);
                Method closeMethod = cl1.getClass().getMethod(CLOSE_METHOD_NAME, new Class[0]);
                closeMethod.invoke((Object)cl1, new Object[0]);
            }
            catch (Throwable e) {
                if (e instanceof NoSuchMethodException) {
                    this.logger.debug((Object)"Probably running in java 6 so close method on URLClassLoader is not available");
                }
                if (e instanceof IOException) {
                    this.logger.error((Object)"Unable to close class loader for plugin. Will try uninstalling plugin anyway", e);
                }
                this.logger.error((Object)"Error while closing class loader", e);
            }
        }
    }

    private boolean hasMarketplacePermission() {
        String[] roleArr;
        Authentication auth = SecurityHelper.getInstance().getAuthentication(PentahoSessionHolder.getSession(), true);
        IPluginResourceLoader resLoader = (IPluginResourceLoader)PentahoSystem.get(IPluginResourceLoader.class, null);
        String roles = null;
        String users = null;
        try {
            roles = resLoader.getPluginSetting(this.getClass(), "settings/marketplace-roles");
            users = resLoader.getPluginSetting(this.getClass(), "settings/marketplace-users");
        }
        catch (Exception e) {
            this.logger.debug((Object)"Error getting data access plugin settings", (Throwable)e);
        }
        if (roles == null) {
            return SecurityHelper.getInstance().isPentahoAdministrator(PentahoSessionHolder.getSession());
        }
        for (String role : roleArr = roles.split(",")) {
            for (GrantedAuthority userRole : auth.getAuthorities()) {
                if (role == null || !role.trim().equals(userRole.getAuthority())) continue;
                return true;
            }
        }
        if (users != null) {
            String[] userArr;
            for (String user : userArr = users.split(",")) {
                if (user == null || !user.trim().equals(auth.getName())) continue;
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String discoverInstalledVersion(IPlugin plugin) {
        block18: {
            String string;
            String versionPath = PentahoSystem.getApplicationContext().getSolutionPath("system/" + plugin.getId() + "/version.xml");
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            InputStreamReader reader = null;
            try {
                File file = new File(versionPath);
                if (!file.exists()) {
                    String string2 = "Unknown";
                    return string2;
                }
                DocumentBuilder db = dbf.newDocumentBuilder();
                Document dom = db.parse(new InputSource(reader = new FileReader(versionPath)));
                NodeList versionElements = dom.getElementsByTagName("version");
                if (versionElements.getLength() < 1) break block18;
                Element versionElement = (Element)versionElements.item(0);
                plugin.setInstalledBuildId(versionElement.getAttribute("buildId"));
                plugin.setInstalledBranch(versionElement.getAttribute("branch"));
                plugin.setInstalledVersion(versionElement.getTextContent());
                string = versionElement.getTextContent();
            }
            catch (Exception e) {
                e.printStackTrace();
                break block18;
            }
            finally {
                try {
                    if (reader != null) {
                        reader.close();
                    }
                }
                catch (Exception e) {}
            }
            return string;
        }
        return "Unknown";
    }

    private Collection<String> getInstalledPluginsFromFileSystem() {
        ArrayList<String> plugins = new ArrayList<String>();
        File systemDir = new File(PentahoSystem.getApplicationContext().getSolutionPath("system/"));
        String[] dirs = systemDir.list((FilenameFilter)DirectoryFileFilter.INSTANCE);
        for (int i = 0; i < dirs.length; ++i) {
            String dir = dirs[i];
            if (!new File(systemDir.getAbsolutePath() + File.separator + dir + File.separator + "plugin.xml").isFile()) continue;
            plugins.add(dir);
        }
        return plugins;
    }

    private boolean withinParentVersion(IPluginVersion pv) {
        VersionInfo versionInfo = VersionHelper.getVersionInfo(PentahoSystem.class);
        String v = versionInfo.getVersionNumber();
        IVersionData pvMax = this.versionDataFactory.create(pv.getMaxParentVersion());
        IVersionData pvMin = this.versionDataFactory.create(pv.getMinParentVersion());
        IVersionData version = this.versionDataFactory.create(v);
        return version.within(pvMin, pvMax);
    }

    private String getElementChildValue(Element element, String child) throws XPathExpressionException {
        Element childElement = (Element)this.xpath.evaluate(child, element, XPathConstants.NODE);
        if (childElement != null) {
            return childElement.getTextContent();
        }
        return null;
    }

    private String getMarketplaceSiteContent() {
        IPluginResourceLoader resLoader = (IPluginResourceLoader)PentahoSystem.get(IPluginResourceLoader.class, null);
        String site = null;
        try {
            site = resLoader.getPluginSetting(this.getClass(), "settings/marketplace-site");
        }
        catch (Exception e) {
            this.logger.debug((Object)"Error getting data access plugin settings", (Throwable)e);
        }
        if (site == null || "".equals(site)) {
            site = MARKETPLACE_ENTRIES_URL_FALLBACK;
        }
        return HttpUtil.getURLContent((String)site);
    }

    private Collection<IPlugin> loadPluginsFromSite() {
        String content = this.getMarketplaceSiteContent();
        if (StringUtils.isEmpty((String)content)) {
            content = this.getMarketplaceSiteContent();
        }
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        try {
            DocumentBuilder db = dbf.newDocumentBuilder();
            Document dom = db.parse(new InputSource(new StringReader(content)));
            NodeList plugins = dom.getElementsByTagName("market_entry");
            ArrayList<IPlugin> pluginList = new ArrayList<IPlugin>();
            for (int i = 0; i < plugins.getLength(); ++i) {
                NodeList availableScreenshots;
                Element pluginElement = (Element)plugins.item(i);
                String type = this.getElementChildValue(pluginElement, "type");
                if (!"Platform".equals(type)) continue;
                IPlugin plugin = (IPlugin)this.pluginFactory.create();
                plugin.setId(this.getElementChildValue(pluginElement, "id"));
                plugin.setName(this.getElementChildValue(pluginElement, "name"));
                plugin.setDescription(this.getElementChildValue(pluginElement, "description"));
                plugin.setAuthorName(this.getElementChildValue(pluginElement, "author"));
                plugin.setAuthorUrl(this.getElementChildValue(pluginElement, "author_url"));
                plugin.setAuthorLogo(this.getElementChildValue(pluginElement, "author_logo"));
                plugin.setImg(this.getElementChildValue(pluginElement, "img"));
                plugin.setSmallImg(this.getElementChildValue(pluginElement, "small_img"));
                plugin.setDocumentationUrl(this.getElementChildValue(pluginElement, "documentation_url"));
                plugin.setInstallationNotes(this.getElementChildValue(pluginElement, "installation_notes"));
                plugin.setLicense(this.getElementChildValue(pluginElement, "license"));
                plugin.setLicenseName(this.getElementChildValue(pluginElement, "license_name"));
                plugin.setLicenseText(this.getElementChildValue(pluginElement, "license_text"));
                plugin.setDependencies(this.getElementChildValue(pluginElement, "dependencies"));
                plugin.setCategory(this.getCategory(pluginElement));
                NodeList availableVersions = (NodeList)this.xpath.evaluate("versions/version", pluginElement, XPathConstants.NODESET);
                if (availableVersions.getLength() > 0) {
                    ArrayList<IPluginVersion> versions = new ArrayList<IPluginVersion>();
                    for (int j = 0; j < availableVersions.getLength(); ++j) {
                        Element versionElement = (Element)availableVersions.item(j);
                        IPluginVersion pv = (IPluginVersion)this.pluginVersionFactory.create();
                        pv.setBranch(this.getElementChildValue(versionElement, "branch"));
                        pv.setName(this.getElementChildValue(versionElement, "name"));
                        pv.setVersion(this.getElementChildValue(versionElement, "version"));
                        pv.setDownloadUrl(this.getElementChildValue(versionElement, "package_url"));
                        pv.setSamplesDownloadUrl(this.getElementChildValue(versionElement, "samples_url"));
                        pv.setDescription(this.getElementChildValue(versionElement, "description"));
                        pv.setChangelog(this.getElementChildValue(versionElement, "changelog"));
                        pv.setBuildId(this.getElementChildValue(versionElement, "build_id"));
                        pv.setReleaseDate(this.getElementChildValue(versionElement, "releaseDate"));
                        pv.setMinParentVersion(this.getElementChildValue(versionElement, "min_parent_version"));
                        pv.setMaxParentVersion(this.getElementChildValue(versionElement, "max_parent_version"));
                        pv.setDevelopmentStage(this.getDevelopmentStage(versionElement));
                        if (!this.withinParentVersion(pv)) continue;
                        versions.add(pv);
                    }
                    plugin.setVersions(versions);
                }
                if ((availableScreenshots = (NodeList)this.xpath.evaluate("screenshots/screenshot", pluginElement, XPathConstants.NODESET)).getLength() > 0) {
                    String[] screenshots = new String[availableScreenshots.getLength()];
                    for (int j = 0; j < availableScreenshots.getLength(); ++j) {
                        Element screenshotElement = (Element)availableScreenshots.item(j);
                        screenshots[j] = screenshotElement.getTextContent();
                    }
                    plugin.setScreenshots(screenshots);
                }
                if (plugin.getVersions() == null || plugin.getVersions().size() <= 0) continue;
                pluginList.add(plugin);
            }
            return pluginList;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private ICategory getCategory(Element pluginElement) throws XPathExpressionException {
        String CATEGORY_ELEMENT_NAME = "category";
        Element categoryElement = (Element)this.xpath.evaluate("category", pluginElement, XPathConstants.NODE);
        if (categoryElement == null) {
            return null;
        }
        return this.getCategoryFromCategoryElement(categoryElement);
    }

    private ICategory getCategoryFromCategoryElement(Element categoryElement) throws XPathExpressionException {
        String PARENT_ELEMENT_NAME = "parent";
        String NAME_ELEMENT_NAME = "name";
        ICategory parent = null;
        Element parentElement = (Element)this.xpath.evaluate("parent", categoryElement, XPathConstants.NODE);
        if (parentElement != null) {
            parent = this.getCategoryFromCategoryElement(parentElement);
        }
        String name = this.getElementChildValue(categoryElement, "name");
        ICategory category = this.categoryFactory.create(name, parent);
        return category;
    }

    private IDevelopmentStage getDevelopmentStage(Element versionElement) throws XPathExpressionException {
        String DEVELOPMENT_STAGE_ELEMENT_NAME = "development_stage";
        String DEVELOPMENT_STAGE_LANE_ELEMENT_NAME = "lane";
        String DEVELOPMENT_STAGE_PHASE_ELEMENT_NAME = "phase";
        Element devStageElement = (Element)this.xpath.evaluate("development_stage", versionElement, XPathConstants.NODE);
        if (devStageElement == null) {
            return null;
        }
        String lane = this.getElementChildValue(devStageElement, "lane");
        String phase = this.getElementChildValue(devStageElement, "phase");
        return new DevelopmentStage(lane, phase);
    }

    private IDomainStatusMessage installPluginAux(String pluginId, String versionBranch) throws MarketplaceSecurityException {
        IPluginVersion v;
        if (!this.hasMarketplacePermission()) {
            throw new MarketplaceSecurityException();
        }
        Collection<IPlugin> plugins = this.getPlugins();
        IPlugin toInstall = null;
        for (IPlugin plugin : plugins) {
            if (!plugin.getId().equals(pluginId)) continue;
            toInstall = plugin;
        }
        if (toInstall == null) {
            return this.domainStatusMessageFactory.create(NO_PLUGIN_ERROR_CODE, "Plugin Not Found");
        }
        if (toInstall.getId().indexOf(".") >= 0) {
            return this.domainStatusMessageFactory.create(NO_PLUGIN_ERROR_CODE, "Plugin ID contains an illegal character");
        }
        this.closeClassLoader(toInstall.getId());
        if (versionBranch != null && versionBranch.length() > 0) {
            v = toInstall.getVersionByBranch(versionBranch);
            if (v == null) {
                return this.domainStatusMessageFactory.create(NO_PLUGIN_ERROR_CODE, "Plugin version not found");
            }
        } else {
            return this.domainStatusMessageFactory.create(FAIL_ERROR_CODE, "Version " + versionBranch + " not found for plugin " + pluginId + ", see log for details.");
        }
        String downloadUrl = v.getDownloadUrl();
        String samplesDownloadUrl = v.getSamplesDownloadUrl();
        String availableVersion = v.getVersion();
        String jobPath = PentahoSystem.getApplicationContext().getSolutionPath("system/marketplace/processes/download_and_install_plugin.kjb");
        try {
            JobMeta installJobMeta = new JobMeta(jobPath, null);
            Job job = new Job(null, installJobMeta);
            File file = new File(PentahoSystem.getApplicationContext().getSolutionPath("system/plugin-cache/downloads"));
            file.mkdirs();
            file = new File(PentahoSystem.getApplicationContext().getSolutionPath("system/plugin-cache/backups"));
            file.mkdirs();
            file = new File(PentahoSystem.getApplicationContext().getSolutionPath("system/plugin-cache/staging"));
            file.mkdirs();
            job.getJobMeta().setParameterValue("downloadUrl", downloadUrl);
            if (toInstall.getVersionByBranch(versionBranch).getSamplesDownloadUrl() != null) {
                job.getJobMeta().setParameterValue("samplesDownloadUrl", samplesDownloadUrl);
                job.getJobMeta().setParameterValue("samplesDir", "/public/plugin-samples");
                job.getJobMeta().setParameterValue("samplesTargetDestination", PentahoSystem.getApplicationContext().getSolutionPath("plugin-samples/" + toInstall.getId()));
                job.getJobMeta().setParameterValue("samplesTargetBackup", PentahoSystem.getApplicationContext().getSolutionPath("system/plugin-cache/backups/" + toInstall.getId() + "_samples_" + new Date().getTime()));
                job.getJobMeta().setParameterValue("samplesDownloadDestination", PentahoSystem.getApplicationContext().getSolutionPath("system/plugin-cache/downloads/" + toInstall.getId() + "-samples-" + availableVersion + "_" + new Date().getTime() + ".zip"));
                job.getJobMeta().setParameterValue("samplesStagingDestination", PentahoSystem.getApplicationContext().getSolutionPath("system/plugin-cache/staging_samples"));
                job.getJobMeta().setParameterValue("samplesStagingDestinationAndDir", PentahoSystem.getApplicationContext().getSolutionPath("system/plugin-cache/staging_samples/" + toInstall.getId()));
            }
            job.getJobMeta().setParameterValue("downloadDestination", PentahoSystem.getApplicationContext().getSolutionPath("system/plugin-cache/downloads/" + toInstall.getId() + "-" + availableVersion + "_" + new Date().getTime() + ".zip"));
            job.getJobMeta().setParameterValue("stagingDestination", PentahoSystem.getApplicationContext().getSolutionPath("system/plugin-cache/staging"));
            job.getJobMeta().setParameterValue("stagingDestinationAndDir", PentahoSystem.getApplicationContext().getSolutionPath("system/plugin-cache/staging/" + toInstall.getId()));
            job.getJobMeta().setParameterValue("targetDestination", PentahoSystem.getApplicationContext().getSolutionPath("system/" + toInstall.getId()));
            job.getJobMeta().setParameterValue("targetBackup", PentahoSystem.getApplicationContext().getSolutionPath("system/plugin-cache/backups/" + toInstall.getId() + "_" + new Date().getTime()));
            job.copyParametersFrom((NamedParams)job.getJobMeta());
            job.setLogLevel(LogLevel.DETAILED);
            job.activateParameters();
            job.start();
            job.waitUntilFinished();
            Result result = job.getResult();
            if (result == null || result.getNrErrors() > 0L) {
                return this.domainStatusMessageFactory.create(FAIL_ERROR_CODE, "Failed to execute install, see log for details.");
            }
        }
        catch (KettleException e) {
            this.logger.error((Object)e.getMessage(), (Throwable)e);
            return this.domainStatusMessageFactory.create(FAIL_ERROR_CODE, "Failed to execute install, see log for details.");
        }
        BaPluginTelemetry telemetryEvent = new BaPluginTelemetry(PLUGIN_NAME);
        HashMap<String, String> extraInfo = new HashMap<String, String>(1);
        extraInfo.put("installedPlugin", toInstall.getId());
        extraInfo.put("installedVersion", availableVersion);
        extraInfo.put("installedBranch", versionBranch);
        telemetryEvent.sendTelemetryRequest(TelemetryHelper.TelemetryEventType.INSTALLATION, extraInfo);
        return this.domainStatusMessageFactory.create(PLUGIN_INSTALLED_CODE, toInstall.getName() + " was successfully installed.  Please restart your BI Server. \n" + toInstall.getInstallationNotes());
    }

    private IDomainStatusMessage uninstallPluginAux(String pluginId) throws MarketplaceSecurityException {
        if (!this.hasMarketplacePermission()) {
            throw new MarketplaceSecurityException();
        }
        Collection<IPlugin> plugins = this.getPlugins();
        IPlugin toUninstall = null;
        for (IPlugin plugin : plugins) {
            if (!plugin.getId().equals(pluginId)) continue;
            toUninstall = plugin;
        }
        if (toUninstall == null) {
            return this.domainStatusMessageFactory.create(NO_PLUGIN_ERROR_CODE, "Plugin Not Found");
        }
        this.closeClassLoader(toUninstall.getId());
        String versionBranch = toUninstall.getInstalledBranch();
        String jobPath = PentahoSystem.getApplicationContext().getSolutionPath("system/marketplace/processes/uninstall_plugin.kjb");
        try {
            JobMeta uninstallJobMeta = new JobMeta(jobPath, null);
            Job job = new Job(null, uninstallJobMeta);
            File file = new File(PentahoSystem.getApplicationContext().getSolutionPath("system/plugin-cache/backups"));
            file.mkdirs();
            String uninstallBackup = PentahoSystem.getApplicationContext().getSolutionPath("system/plugin-cache/backups/" + toUninstall.getId() + "_" + new Date().getTime());
            job.getJobMeta().setParameterValue("uninstallLocation", PentahoSystem.getApplicationContext().getSolutionPath("system/" + toUninstall.getId()));
            job.getJobMeta().setParameterValue("uninstallBackup", uninstallBackup);
            job.getJobMeta().setParameterValue("samplesDir", "/public/plugin-samples/" + toUninstall.getId());
            job.copyParametersFrom((NamedParams)job.getJobMeta());
            job.activateParameters();
            job.start();
            job.waitUntilFinished();
            Result result = job.getResult();
            if (result == null || result.getNrErrors() > 0L) {
                return this.domainStatusMessageFactory.create(FAIL_ERROR_CODE, "Failed to execute uninstall, see log for details.");
            }
        }
        catch (KettleException e) {
            this.logger.error((Object)e.getMessage(), (Throwable)e);
        }
        BaPluginTelemetry telemetryEvent = new BaPluginTelemetry(PLUGIN_NAME);
        HashMap<String, String> extraInfo = new HashMap<String, String>(1);
        extraInfo.put("uninstalledPlugin", toUninstall.getId());
        extraInfo.put("uninstalledPluginVersion", toUninstall.getInstalledVersion());
        extraInfo.put("uninstalledPluginBranch", toUninstall.getInstalledBranch());
        telemetryEvent.sendTelemetryRequest(TelemetryHelper.TelemetryEventType.REMOVAL, extraInfo);
        return this.domainStatusMessageFactory.create(PLUGIN_UNINSTALLED_CODE, toUninstall.getName() + " was successfully uninstalled.  Please restart your BI Server.");
    }

    @Override
    public Collection<IPlugin> getPlugins() {
        Collection<IPlugin> plugins = this.loadPluginsFromSite();
        Collection<String> installedPlugins = this.getInstalledPluginsFromFileSystem();
        if (installedPlugins.size() > 0) {
            HashMap<String, IPlugin> marketplacePlugins = new HashMap<String, IPlugin>();
            if (plugins != null) {
                for (IPlugin plugin : plugins) {
                    marketplacePlugins.put(plugin.getId(), plugin);
                }
            }
            for (String installedPlugin : installedPlugins) {
                IPlugin plugin = (IPlugin)marketplacePlugins.get(installedPlugin);
                if (plugin == null) continue;
                plugin.setInstalled(true);
                this.discoverInstalledVersion(plugin);
            }
        }
        return plugins;
    }

    @Override
    public IDomainStatusMessage installPlugin(String pluginId, String versionBranch) {
        try {
            IDomainStatusMessage msg = this.installPluginAux(pluginId, versionBranch);
            return msg;
        }
        catch (MarketplaceSecurityException e) {
            this.logger.debug((Object)e.getMessage(), (Throwable)e);
            return this.domainStatusMessageFactory.create(UNAUTHORIZED_ACCESS_ERROR_CODE, UNAUTHORIZED_ACCESS_MESSAGE);
        }
    }

    @Override
    public IDomainStatusMessage uninstallPlugin(String pluginId) {
        try {
            IDomainStatusMessage msg = this.uninstallPluginAux(pluginId);
            return msg;
        }
        catch (MarketplaceSecurityException e) {
            this.logger.debug((Object)e.getMessage(), (Throwable)e);
            return this.domainStatusMessageFactory.create(UNAUTHORIZED_ACCESS_ERROR_CODE, UNAUTHORIZED_ACCESS_MESSAGE);
        }
    }

    private static class MarketplaceSecurityException
    extends Exception {
        private static final long serialVersionUID = -1852471739131561628L;

        private MarketplaceSecurityException() {
        }
    }
}

