/*
 * Decompiled with CFR 0.152.
 */
package com.tonbeller.wcf.utils;

import com.tonbeller.tbutils.res.Resources;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public abstract class I18nReplacer {
    public static final String PREFIX = "fmt:";

    public static I18nReplacer instance(final ResourceBundle resb) {
        return new I18nReplacer(){

            protected String internalReplace(String key) {
                try {
                    return resb.getString(key);
                }
                catch (MissingResourceException e) {
                    return "???" + key + "???";
                }
            }
        };
    }

    public static I18nReplacer instance(final Resources res) {
        return new I18nReplacer(){

            protected String internalReplace(String key) {
                try {
                    return res.getString(key);
                }
                catch (MissingResourceException e) {
                    return "???" + key + "???";
                }
            }
        };
    }

    protected abstract String internalReplace(String var1);

    public String replace(String value) {
        if (value.startsWith(PREFIX)) {
            return this.internalReplace(value.substring(4));
        }
        return value;
    }

    public void replaceAll(Node root) {
        Text text;
        String data;
        if (root.getNodeType() == 1) {
            Element e = (Element)root;
            NamedNodeMap atts = e.getAttributes();
            int N = atts.getLength();
            for (int i = 0; i < N; ++i) {
                Attr attr = (Attr)atts.item(i);
                String value = attr.getValue();
                if (!value.startsWith(PREFIX)) continue;
                value = this.internalReplace(value.substring(4));
                attr.setValue(value);
            }
        }
        if (root.getNodeType() == 3 && (data = (text = (Text)root).getData()).startsWith(PREFIX)) {
            data = this.internalReplace(data.substring(4));
            text.setData(data);
        }
        NodeList list = root.getChildNodes();
        int N = list.getLength();
        for (int i = 0; i < N; ++i) {
            this.replaceAll(list.item(i));
        }
    }
}

