/*
 * Decompiled with CFR 0.152.
 */
package com.tonbeller.wcf.toolbar;

import com.tonbeller.tbutils.res.Resources;
import com.tonbeller.wcf.bookmarks.Bookmarkable;
import com.tonbeller.wcf.component.Component;
import com.tonbeller.wcf.component.NestableComponentSupport;
import com.tonbeller.wcf.controller.RequestContext;
import com.tonbeller.wcf.toolbar.ImgButton;
import com.tonbeller.wcf.toolbar.ToolBarComponent;
import com.tonbeller.wcf.toolbar.ToolButton;
import com.tonbeller.wcf.toolbar.ToolSeparator;
import com.tonbeller.wcf.utils.XoplonNS;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.MissingResourceException;
import org.apache.log4j.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class ToolBar
extends NestableComponentSupport
implements Bookmarkable {
    private static Logger logger = Logger.getLogger((Class)ToolBar.class);
    private Resources resb;
    private List content = new ArrayList();
    private Map buttonMap = new HashMap();
    private Map radioGroups = new HashMap();
    private boolean globalButtonIds = false;

    public ToolBar(String id, Component parent) {
        super(id, parent);
    }

    public void initialize(RequestContext context) throws Exception {
        super.initialize(context);
        Iterator it = this.content.iterator();
        while (it.hasNext()) {
            ToolBarComponent cc = (ToolBarComponent)it.next();
            cc.initialize(context, this);
        }
    }

    public Element render(RequestContext context, Document factory) throws Exception {
        Element root = XoplonNS.createElement(factory, "tool-bar");
        ToolBarComponent separator = null;
        boolean foundButton = false;
        Iterator it = this.content.iterator();
        while (it.hasNext()) {
            ToolBarComponent cc = (ToolBarComponent)it.next();
            if (!cc.isVisible(context)) continue;
            if (cc.isSeparator()) {
                separator = cc;
                continue;
            }
            if (foundButton && separator != null) {
                separator.render(context, root);
            }
            separator = null;
            foundButton = true;
            cc.render(context, root);
        }
        return root;
    }

    public Map getButtons() {
        return this.buttonMap;
    }

    public void addButton(ToolButton button) {
        this.content.add(button);
        List list = this.getRadioGroup(button);
        if (list != null) {
            list.add(button);
        }
        this.buttonMap.put(button.getId(), button);
    }

    public List getRadioGroup(ToolButton button) {
        String group = button.getRadioGroup();
        if (group == null || group.length() == 0) {
            return null;
        }
        ArrayList list = (ArrayList)this.radioGroups.get(group);
        if (list == null) {
            list = new ArrayList();
            this.radioGroups.put(group, list);
        }
        return list;
    }

    public void addSeparator(ToolSeparator separator) {
        this.content.add(separator);
    }

    public void addImgButton(ImgButton button) {
        this.content.add(button);
        this.buttonMap.put(button.getId(), button);
    }

    public Object retrieveBookmarkState(int levelOfDetail) {
        Map map = (Map)super.retrieveBookmarkState(levelOfDetail);
        Iterator it = this.content.iterator();
        while (it.hasNext()) {
            ToolBarComponent cc = (ToolBarComponent)it.next();
            map.put(cc.getId(), new Boolean(cc.isVisible()));
        }
        return map;
    }

    public void setBookmarkState(Object state) {
        super.setBookmarkState(state);
        Map map = (Map)state;
        Iterator it = this.content.iterator();
        while (it.hasNext()) {
            ToolBarComponent cc = (ToolBarComponent)it.next();
            Boolean b = (Boolean)map.get(cc.getId());
            if (b == null) continue;
            cc.setVisible(b);
        }
    }

    public String getTooltip(String tooltip) {
        try {
            if (tooltip == null) {
                return "";
            }
            if (this.resb != null) {
                return this.resb.getString(tooltip);
            }
            return tooltip;
        }
        catch (MissingResourceException e) {
            logger.error((Object)("missing resource for " + tooltip));
            return tooltip;
        }
    }

    public void setBundle(Resources resb) {
        this.resb = resb;
    }

    public boolean isGlobalButtonIds() {
        return this.globalButtonIds;
    }

    public void setGlobalButtonIds(boolean globalButtonIds) {
        this.globalButtonIds = globalButtonIds;
    }
}

