/*
 * Decompiled with CFR 0.152.
 */
package com.tonbeller.wcf.toolbar;

import com.tonbeller.wcf.controller.RequestContext;
import com.tonbeller.wcf.toolbar.ToolBar;
import com.tonbeller.wcf.toolbar.ToolBarComponentSupport;
import com.tonbeller.wcf.utils.DomUtils;
import java.text.MessageFormat;
import org.w3c.dom.Element;

public class ImgButton
extends ToolBarComponentSupport {
    private ToolBar tbar;
    private String tooltip;
    private String href;
    private String target;
    private String img;

    public ImgButton(ToolBar tbar) {
        this.tbar = tbar;
    }

    public void render(RequestContext context, Element parent) throws Exception {
        Element btn = DomUtils.appendElement(parent, "img-button");
        btn.setAttribute("img", this.img + "-up");
        btn.setAttribute("id", this.getId());
        btn.setAttribute("href", this.makeHref(context));
        if (this.target != null && this.target.length() != 0) {
            btn.setAttribute("target", this.target);
        }
        btn.setAttribute("title", this.tbar.getTooltip(this.tooltip));
    }

    String makeHref(RequestContext context) {
        Object[] args = new Object[]{context.getRequest().getContextPath(), DomUtils.randomId()};
        return MessageFormat.format(this.href, args);
    }

    public void initialize(RequestContext context, ToolBar owner) {
    }

    public String getHref() {
        return this.href;
    }

    public String getImg() {
        return this.img;
    }

    public String getTarget() {
        return this.target;
    }

    public void setHref(String href) {
        this.href = href;
    }

    public void setImg(String img) {
        this.img = img;
    }

    public void setTarget(String target) {
        this.target = target;
    }

    public void setTooltip(String tooltip) {
        this.tooltip = tooltip;
    }

    public boolean isSeparator() {
        return false;
    }
}

