/*
 * Decompiled with CFR 0.152.
 */
package com.tonbeller.wcf.table;

import com.tonbeller.wcf.table.TableModel;
import com.tonbeller.wcf.table.TableModelChangeEvent;
import com.tonbeller.wcf.table.TableModelDecorator;
import com.tonbeller.wcf.table.TableRow;

class PagedTableModel
extends TableModelDecorator {
    private int pageSize = 10;
    private int currentPage;
    private boolean showAll = false;

    public PagedTableModel() {
    }

    public PagedTableModel(TableModel model) {
        super(model);
    }

    public int getRowCount() {
        if (this.showAll) {
            return super.getRowCount();
        }
        this.validate();
        int offs = this.currentPage * this.pageSize;
        int rows = super.getRowCount();
        if (offs + this.pageSize > rows) {
            return rows - offs;
        }
        return this.pageSize;
    }

    public TableRow getRow(int rowIndex) {
        if (this.showAll) {
            return super.getRow(rowIndex);
        }
        this.validate();
        return super.getRow(rowIndex + this.currentPage * this.pageSize);
    }

    public void setPageSize(int newPageSize) {
        this.pageSize = newPageSize;
        if (this.pageSize < 1) {
            this.pageSize = 1;
        }
    }

    public int getPageSize() {
        return this.pageSize;
    }

    public void setCurrentPage(int newCurrentPage) {
        this.currentPage = newCurrentPage;
    }

    public int getCurrentPage() {
        return this.currentPage;
    }

    public int getPageCount() {
        int rc = super.getRowCount();
        int pc = rc / this.pageSize;
        if (rc % this.pageSize != 0) {
            ++pc;
        }
        return pc;
    }

    void validate() {
        int pageCount = this.getPageCount();
        if (this.currentPage >= pageCount) {
            this.currentPage = pageCount - 1;
        }
        if (this.currentPage < 0) {
            this.currentPage = 0;
        }
    }

    public void setShowAll(boolean newShowAll) {
        this.showAll = newShowAll;
    }

    public boolean isShowAll() {
        return this.showAll;
    }

    public void tableModelChanged(TableModelChangeEvent event) {
        this.currentPage = 0;
        this.validate();
    }
}

