/*
 * Decompiled with CFR 0.152.
 */
package com.tonbeller.wcf.param;

import com.tonbeller.tbutils.res.Resources;
import com.tonbeller.wcf.param.SessionParam;
import com.tonbeller.wcf.param.SqlValueMap;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpSession;
import javax.servlet.jsp.PageContext;
import org.apache.log4j.Logger;

public class SessionParamPool
implements Map {
    private static final String SQL_VALUE_MAP = "sqlValueMap";
    private static final String PARAM_POOL = "paramPool";
    private static final Logger logger = Logger.getLogger((Class)SessionParamPool.class);
    private SqlValueMap sqlValueMap;
    private Map map = new HashMap();

    protected SessionParamPool() {
        this.sqlValueMap = new SqlValueMap(this);
    }

    static SessionParamPool instance() {
        return SessionParamPool.createInstance();
    }

    public static SessionParamPool instance(HttpSession session) {
        if (session == null) {
            return SessionParamPool.createInstance();
        }
        SessionParamPool p = (SessionParamPool)session.getAttribute(PARAM_POOL);
        if (p == null) {
            p = SessionParamPool.createInstance();
            session.setAttribute(PARAM_POOL, (Object)p);
            session.setAttribute(SQL_VALUE_MAP, (Object)p.getSqlValueMap());
        }
        return p;
    }

    protected static SessionParamPool createInstance() {
        String clazz = SessionParamPool.class.getName();
        clazz = Resources.instance().getOptionalString(clazz, clazz);
        try {
            return (SessionParamPool)Class.forName(clazz).newInstance();
        }
        catch (InstantiationException e) {
            logger.error(null, (Throwable)e);
            throw new IllegalArgumentException(clazz);
        }
        catch (IllegalAccessException e) {
            logger.error(null, (Throwable)e);
            throw new IllegalArgumentException(clazz);
        }
        catch (ClassNotFoundException e) {
            logger.error(null, (Throwable)e);
            throw new IllegalArgumentException(clazz);
        }
    }

    public static SessionParamPool instance(PageContext pageContext) {
        SessionParamPool p = (SessionParamPool)pageContext.findAttribute(PARAM_POOL);
        if (p == null) {
            return SessionParamPool.instance(pageContext.getSession());
        }
        return p;
    }

    public SessionParam getParam(String name) {
        return (SessionParam)this.map.get(name);
    }

    public SessionParam setParam(SessionParam p) {
        return this.map.put(p.getName(), p);
    }

    public Map pushParams(Collection c) {
        HashMap<String, SessionParam> memento = new HashMap<String, SessionParam>();
        Iterator it = c.iterator();
        while (it.hasNext()) {
            SessionParam param = (SessionParam)it.next();
            SessionParam prev = this.setParam(param);
            String name = param.getName();
            if (memento.containsKey(name)) continue;
            memento.put(name, prev);
        }
        return memento;
    }

    public void popParams(Map memento) {
        Iterator it = memento.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry e = it.next();
            SessionParam p = (SessionParam)e.getValue();
            if (p == null) {
                this.removeParam((String)e.getKey());
                continue;
            }
            this.setParam(p);
        }
    }

    public void removeParam(SessionParam p) {
        this.map.remove(p.getName());
    }

    public SessionParam removeParam(String name) {
        return (SessionParam)this.map.remove(name);
    }

    public Map getSqlValueMap() {
        return this.sqlValueMap;
    }

    public int size() {
        return this.map.size();
    }

    public void clear() {
        this.map.clear();
    }

    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    public boolean containsKey(Object key) {
        return this.map.containsKey(key);
    }

    public boolean containsValue(Object value) {
        return this.map.containsValue(value);
    }

    public Collection values() {
        return this.map.values();
    }

    public void putAll(Map t) {
        this.map.putAll(t);
    }

    public Set entrySet() {
        return this.map.entrySet();
    }

    public Set keySet() {
        return this.map.keySet();
    }

    public Object get(Object key) {
        return this.map.get(key);
    }

    public Object remove(Object key) {
        return this.map.remove(key);
    }

    public Object put(Object key, Object value) {
        return this.map.put(key, value);
    }
}

