/*
 * Decompiled with CFR 0.152.
 */
package com.tonbeller.wcf.form;

import com.tonbeller.wcf.component.Component;
import com.tonbeller.wcf.component.FormListener;
import com.tonbeller.wcf.controller.RequestContext;
import com.tonbeller.wcf.controller.RequestListener;
import com.tonbeller.wcf.convert.ConvertException;
import com.tonbeller.wcf.form.ActionReferenceException;
import com.tonbeller.wcf.form.FormBean;
import com.tonbeller.wcf.form.XmlComponent;
import com.tonbeller.wcf.format.FormatException;
import com.tonbeller.wcf.ui.XoplonCtrl;
import com.tonbeller.wcf.utils.DomUtils;
import com.tonbeller.wcf.utils.IdGenerator;
import com.tonbeller.wcf.utils.SoftException;
import com.tonbeller.wcf.utils.XoplonNS;
import com.tonbeller.wcf.wizard.PageListener;
import com.tonbeller.wcf.wizard.WizardPage;
import com.tonbeller.wcf.wizard.WizardPageSupport;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Iterator;
import java.util.Map;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.log4j.Logger;
import org.jaxen.JaxenException;
import org.jaxen.dom.DOMXPath;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class FormComponent
extends XmlComponent
implements FormListener,
WizardPage {
    private boolean dirty = true;
    boolean haveError = false;
    Object bean;
    boolean bookmarkable = false;
    boolean finishButton = true;
    WizardPageSupport wizardPageSupport = new WizardPageSupport(this);
    private static Logger logger = Logger.getLogger((Class)FormComponent.class);
    static /* synthetic */ Class class$com$tonbeller$wcf$controller$RequestContext;

    public FormComponent(String id, Component parent, Document document) {
        this(id, parent, document, null);
        this.bean = this;
    }

    public FormComponent(String id, Component parent, Document document, Object bean) {
        super(id, parent, document);
        this.bean = bean;
        Element rootElem = document.getDocumentElement();
        if (rootElem.getAttribute("id").length() == 0) {
            rootElem.setAttribute("id", id);
        }
        new IdGenerator().generate(document, id + ".");
    }

    public void revert(RequestContext context) {
        super.revert(context);
        try {
            this.clearErrors();
            context.getConverter().revert(this.bean, this.getDocument());
            this.dirty = false;
            this.haveError = false;
        }
        catch (ConvertException e) {
            logger.error((Object)"exception caught", (Throwable)e);
            throw new SoftException(e);
        }
    }

    public boolean validate(RequestContext context) {
        boolean success = super.validate(context);
        try {
            logger.info((Object)"enter");
            context.getConverter().validate(context.getParameters(), context.getFileParameters(), this.getDocument(), this.bean);
            return success;
        }
        catch (ConvertException e) {
            logger.error(null, (Throwable)e);
            throw new SoftException(e);
        }
        catch (FormatException e) {
            logger.info((Object)("invalid user input: " + e.getMessage()));
            this.haveError = true;
            return false;
        }
    }

    public void initialize(RequestContext context) throws Exception {
        super.initialize(context);
        this.initActionReferences();
        this.dirty = true;
        if (this.bean instanceof FormBean) {
            ((FormBean)this.bean).setFormComponent(context, this);
        }
    }

    public Document render(RequestContext context) throws Exception {
        if (this.dirty || !this.haveError) {
            this.revert(context);
        }
        return super.render(context);
    }

    public void setBean(Object bean) {
        this.bean = bean;
        this.dirty = true;
    }

    public Object getBean() {
        return this.bean;
    }

    public void setError(String id, String message) {
        Element elem = DomUtils.findElementWithId(id, this.getDocument().getDocumentElement());
        if (elem == null) {
            logger.error((Object)("No errorElement found with id=" + id + " in XML form"));
            return;
        }
        if (message == null) {
            DomUtils.removeAttribute(elem, "error");
        } else {
            elem.setAttribute("error", message);
        }
        this.haveError = true;
    }

    public void clearErrors() {
        this.clearErrors(this.getDocument().getChildNodes());
        this.haveError = false;
    }

    protected void clearErrors(NodeList list) {
        int len = list.getLength();
        for (int i = 0; i < len; ++i) {
            Node n = list.item(i);
            if (n.getNodeType() != 1) continue;
            Element x = (Element)list.item(i);
            DomUtils.removeAttribute(x, "error");
            this.clearErrors(x.getChildNodes());
        }
    }

    private void initActionReferences() {
        try {
            DOMXPath dx = new DOMXPath("//*[@actionReference]");
            Iterator it = dx.selectNodes((Object)this.getDocument()).iterator();
            while (it.hasNext()) {
                Element elem = (Element)it.next();
                String methodPath = elem.getAttribute("actionReference");
                if ("none".equals(methodPath)) continue;
                ActionReferenceListener rl = new ActionReferenceListener(elem, methodPath);
                String id = elem.getAttribute("id");
                this.getDispatcher().addRequestListener(id, null, rl);
            }
        }
        catch (JaxenException e) {
            logger.error(null, (Throwable)e);
        }
    }

    public Object retrieveBookmarkState(int levelOfDetail) {
        if (!this.bookmarkable) {
            return null;
        }
        Map map = (Map)super.retrieveBookmarkState(levelOfDetail);
        try {
            DOMXPath dx = new DOMXPath("//*[@modelReference]");
            Iterator it = dx.selectNodes((Object)this.getDocument()).iterator();
            while (it.hasNext()) {
                Element elem = (Element)it.next();
                if ("false".equals(elem.getAttribute("bookmark"))) continue;
                String ref = XoplonCtrl.getModelReference(elem);
                Object value = PropertyUtils.getProperty((Object)this.bean, (String)ref);
                map.put(ref, value);
            }
        }
        catch (JaxenException e) {
            logger.error((Object)"?", (Throwable)e);
        }
        catch (IllegalAccessException e) {
            logger.error((Object)"?", (Throwable)e);
        }
        catch (InvocationTargetException e) {
            logger.error((Object)"?", (Throwable)e);
        }
        catch (NoSuchMethodException e) {
            logger.error((Object)"?", (Throwable)e);
        }
        return map;
    }

    public void setBookmarkState(Object state) {
        if (!this.bookmarkable) {
            return;
        }
        if (!(state instanceof Map)) {
            return;
        }
        super.setBookmarkState(state);
        Map map = (Map)state;
        try {
            DOMXPath dx = new DOMXPath("//*[@modelReference]");
            Iterator it = dx.selectNodes((Object)this.getDocument()).iterator();
            while (it.hasNext()) {
                Element elem = (Element)it.next();
                if ("false".equals(elem.getAttribute("bookmark"))) continue;
                try {
                    String ref = XoplonCtrl.getModelReference(elem);
                    Object value = map.get(ref);
                    if (value == null) continue;
                    PropertyUtils.setProperty((Object)this.bean, (String)ref, value);
                }
                catch (IllegalAccessException e1) {
                    logger.error(null, (Throwable)e1);
                }
                catch (InvocationTargetException e1) {
                    logger.error(null, (Throwable)e1);
                    logger.error(null, e1.getTargetException());
                }
                catch (NoSuchMethodException e1) {
                    logger.warn(null, (Throwable)e1);
                }
            }
        }
        catch (JaxenException e) {
            logger.error(null, (Throwable)e);
        }
    }

    public boolean isBookmarkable() {
        return this.bookmarkable;
    }

    public void setBookmarkable(boolean b) {
        this.bookmarkable = b;
    }

    public void addPageListener(PageListener l) {
        this.wizardPageSupport.addPageListener(l);
    }

    public void removePageListener(PageListener l) {
        this.wizardPageSupport.removePageListener(l);
    }

    public void pageAdded(WizardPage.WizardPagePosition pagePos) {
        boolean isBack = false;
        boolean isNext = false;
        boolean isFinish = false;
        boolean isOk = false;
        boolean isCancel = true;
        if (pagePos == WizardPage.WizardPagePosition.FIRST_PAGE) {
            isNext = true;
            isFinish = this.isFinishButton();
        } else if (pagePos == WizardPage.WizardPagePosition.MIDDLE_PAGE) {
            isNext = true;
            isBack = true;
            isFinish = this.isFinishButton();
        } else if (pagePos == WizardPage.WizardPagePosition.LAST_PAGE) {
            isNext = false;
            isBack = true;
            isFinish = true;
        } else if (pagePos == WizardPage.WizardPagePosition.SINGLE_PAGE) {
            isOk = true;
        }
        this.showButton("back", isBack);
        this.showButton("next", isNext);
        this.showButton("finish", isFinish);
        this.showButton("ok", isOk);
        this.showButton("cancel", isCancel);
    }

    private void showButton(String name, boolean show) {
        Element btn = this.getElement(this.getId() + "." + name);
        if (btn == null) {
            return;
        }
        if (XoplonNS.getAttribute(btn, "hidden") != null) {
            XoplonNS.removeAttribute(btn, "hidden");
        }
        if (!show) {
            XoplonNS.setAttribute(btn, "hidden", "true");
        }
    }

    public boolean isFinishButton() {
        return this.finishButton;
    }

    public void setFinishButton(boolean finishButton) {
        this.finishButton = finishButton;
    }

    public void pageSkipped() {
    }

    private class ActionReferenceListener
    implements RequestListener {
        private Element elem;
        private String methodPath;

        public ActionReferenceListener(Element elem, String methodPath) {
            this.elem = elem;
            this.methodPath = methodPath;
        }

        public void request(RequestContext context) throws Exception {
            String action = this.elem.getAttribute("action");
            if (action.equals("revert")) {
                FormComponent.this.revert(context);
            } else if (action.equals("validate") && !FormComponent.this.validate(context)) {
                return;
            }
            Object[] state = this.performButtonActions(context);
            if (!this.invokeActionReference(context)) {
                this.restoreButtonActions(context, state);
                return;
            }
            FormComponent.this.wizardPageSupport.fireWizardButton(context, this.methodName());
        }

        private String methodName() {
            String methodName = this.methodPath;
            int index = this.methodPath.lastIndexOf(46);
            if (index > 0) {
                methodName = this.methodPath.substring(index + 1);
            }
            return methodName;
        }

        private Object beanTarget() throws IllegalAccessException, InvocationTargetException, NoSuchMethodException {
            Object target = FormComponent.this.bean;
            String methodName = this.methodPath;
            int index = this.methodPath.lastIndexOf(46);
            if (index > 0) {
                String beanPath = this.methodPath.substring(0, index);
                target = PropertyUtils.getProperty((Object)target, (String)beanPath);
            }
            return target;
        }

        private Object[] performButtonActions(RequestContext context) {
            String successAttr;
            Object[] state = new Object[2];
            state[0] = FormComponent.this.isVisible();
            if ("true".equals(this.elem.getAttribute("hide"))) {
                FormComponent.this.setVisible(false);
            }
            state[1] = FormComponent.this.getNextView();
            String forward = this.elem.getAttribute("forward");
            if (forward != null && forward.length() > 0) {
                FormComponent.this.setNextView(forward);
            }
            if ((successAttr = this.elem.getAttribute("successAttr")).length() > 0) {
                context.getRequest().setAttribute(successAttr, (Object)"true");
            }
            return state;
        }

        private void restoreButtonActions(RequestContext context, Object[] state) {
            FormComponent.this.setVisible((Boolean)state[0]);
            FormComponent.this.setNextView((String)state[1]);
            String successAttr = this.elem.getAttribute("successAttr");
            if (successAttr.length() > 0) {
                context.getRequest().removeAttribute(successAttr);
            }
        }

        private boolean invokeActionReference(RequestContext context) throws IllegalAccessException, InvocationTargetException {
            if (FormComponent.this.bean == null) {
                return true;
            }
            try {
                Object target = this.beanTarget();
                String methodName = this.methodName();
                Class<?> c = target.getClass();
                Method m = c.getMethod(methodName, class$com$tonbeller$wcf$controller$RequestContext == null ? (class$com$tonbeller$wcf$controller$RequestContext = FormComponent.class$("com.tonbeller.wcf.controller.RequestContext")) : class$com$tonbeller$wcf$controller$RequestContext);
                m.invoke(target, context);
                return true;
            }
            catch (NoSuchMethodException e) {
                logger.error((Object)("method not found: " + this.methodPath + " in " + FormComponent.this.bean));
                return true;
            }
            catch (InvocationTargetException e) {
                Throwable t = e.getTargetException();
                if (t instanceof ActionReferenceException) {
                    return false;
                }
                throw e;
            }
        }
    }
}

