/*
 * Decompiled with CFR 0.152.
 */
package com.tonbeller.wcf.form;

import com.tonbeller.wcf.controller.RequestContext;
import com.tonbeller.wcf.controller.RequestListener;
import com.tonbeller.wcf.form.NodeHandler;
import com.tonbeller.wcf.form.XmlComponent;
import com.tonbeller.wcf.scroller.Scroller;
import com.tonbeller.wcf.ui.Button;
import javax.servlet.http.HttpSession;
import org.apache.log4j.Logger;
import org.w3c.dom.Element;

public class ButtonHandler
implements NodeHandler,
RequestListener {
    private XmlComponent comp;
    private Element element;
    private boolean pressed = false;
    private boolean success = true;
    public static final String NO_ACTION = "";
    public static final String VALIDATE_ACTION = "validate";
    public static final String REVERT_ACTION = "revert";
    private static Logger logger = Logger.getLogger((Class)ButtonHandler.class);

    public void initialize(RequestContext context, XmlComponent comp, Element element) {
        this.comp = comp;
        this.element = element;
        comp.getDispatcher().addRequestListener(Button.getId(element), null, this);
    }

    public void destroy(HttpSession session) {
    }

    public void request(RequestContext context) throws Exception {
        if (this.element.getAttribute("scroller") != null) {
            Scroller.enableScroller(context);
        }
        this.pressed = true;
        this.success = true;
        String action = this.element.getAttribute("action");
        if (action.equals(REVERT_ACTION)) {
            this.comp.revert(context);
        } else if (action.equals(VALIDATE_ACTION)) {
            this.success = this.comp.validate(context);
        }
        if (this.success) {
            String successAttr;
            String forward;
            boolean hide = "true".equals(this.element.getAttribute("hide"));
            if (hide) {
                this.comp.setVisible(false);
            }
            if ((forward = this.element.getAttribute("forward")) != null && forward.length() > 0) {
                this.comp.setNextView(forward);
            }
            if ((successAttr = this.element.getAttribute("successAttr")).length() > 0) {
                context.getRequest().setAttribute(successAttr, (Object)"true");
            }
        }
    }

    public void render(RequestContext context) throws Exception {
    }
}

