/*
 * Decompiled with CFR 0.152.
 */
package com.tonbeller.wcf.controller;

import com.tonbeller.wcf.utils.SoftException;
import com.tonbeller.wcf.utils.UrlUtils;
import java.io.IOException;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;

public class FacesServlet
extends HttpServlet {
    final String errorJSP;
    private static Logger logger = Logger.getLogger((Class)FacesServlet.class);

    public FacesServlet() {
        this.errorJSP = null;
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.doPost(request, response);
    }

    protected void doPost(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        RequestDispatcher rd;
        String jspUri;
        String facesUri = req.getServletPath();
        if (facesUri.equals(jspUri = UrlUtils.forceExtension(facesUri, ".faces", ".jsp"))) {
            throw new ServletException("faces mapped to jsp");
        }
        if (logger.isInfoEnabled()) {
            logger.info((Object)("FacesServlet: " + facesUri + " -> " + jspUri));
        }
        if ((rd = req.getRequestDispatcher(jspUri)) == null) {
            throw new IllegalArgumentException("could not find RequestDispatcher for " + jspUri);
        }
        try {
            rd.forward((ServletRequest)req, (ServletResponse)res);
        }
        catch (Exception e) {
            logger.error(null, (Throwable)e);
            if (this.errorJSP != null) {
                try {
                    logger.error((Object)("redirecting to error page " + this.errorJSP), (Throwable)e);
                    req.setAttribute("javax.servlet.jsp.jspException", (Object)e);
                    req.getRequestDispatcher(this.errorJSP).forward((ServletRequest)req, (ServletResponse)res);
                }
                catch (Exception e2) {
                    throw new SoftException(e);
                }
            }
            throw new SoftException(e);
        }
    }
}

