/*
 * Decompiled with CFR 0.152.
 */
package com.tonbeller.wcf.component;

import com.tonbeller.wcf.bookmarks.Bookmarkable;
import com.tonbeller.wcf.component.Component;
import com.tonbeller.wcf.component.Form;
import com.tonbeller.wcf.component.FormListener;
import com.tonbeller.wcf.component.FormSupport;
import com.tonbeller.wcf.component.RoleExprHolder;
import com.tonbeller.wcf.component.Visible;
import com.tonbeller.wcf.controller.Controller;
import com.tonbeller.wcf.controller.Dispatcher;
import com.tonbeller.wcf.controller.DispatcherSupport;
import com.tonbeller.wcf.controller.RequestContext;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.servlet.http.HttpSession;
import javax.servlet.http.HttpSessionBindingEvent;
import javax.servlet.http.HttpSessionBindingListener;
import org.apache.log4j.Logger;

public abstract class ComponentSupport
implements Component,
Form,
HttpSessionBindingListener,
Visible,
RoleExprHolder,
Bookmarkable {
    private static Logger logger = Logger.getLogger((Class)ComponentSupport.class);
    private String id;
    private String roleExpr;
    private Dispatcher dispatcher = new DispatcherSupport();
    private Form form = new FormSupport();
    private Locale locale;
    private boolean visible = true;
    private Controller controller;
    private Component parent;
    private boolean autoValidate;

    public ComponentSupport(String id, Component parent) {
        this.id = id;
        this.parent = parent;
    }

    public Dispatcher getDispatcher() {
        return this.dispatcher;
    }

    public void initialize(RequestContext context) throws Exception {
        logger.info((Object)this.id);
        this.locale = context.getLocale();
        this.controller = Controller.instance(context.getSession());
        this.controller.addRequestListener(this);
    }

    public void destroy(HttpSession session) throws Exception {
        logger.info((Object)this.id);
        this.dispatcher.clear();
        if (this.controller == null) {
            throw new IllegalStateException("not initialized");
        }
        this.controller.removeRequestListener(this);
        this.controller = null;
    }

    public void request(RequestContext context) throws Exception {
        if (this.autoValidate) {
            this.validate(context);
        }
        this.dispatcher.request(context);
    }

    public void valueBound(HttpSessionBindingEvent e) {
    }

    public void valueUnbound(HttpSessionBindingEvent ev) {
        try {
            this.destroy(ev.getSession());
        }
        catch (Exception ex) {
            ex.printStackTrace();
            logger.error((Object)this.id, (Throwable)ex);
        }
    }

    public String getId() {
        return this.id;
    }

    public boolean isVisible() {
        return this.visible;
    }

    public void setVisible(boolean b) {
        this.visible = b;
    }

    public Form getForm() {
        return this.form;
    }

    public void setId(String string) {
        this.id = string;
    }

    public Locale getLocale() {
        return this.locale;
    }

    public String getRoleExpr() {
        return this.roleExpr;
    }

    public void setRoleExpr(String roleExpr) {
        this.roleExpr = roleExpr;
    }

    public Object retrieveBookmarkState(int levelOfDetail) {
        HashMap<String, Boolean> map = new HashMap<String, Boolean>();
        map.put("visible", new Boolean(this.isVisible()));
        return map;
    }

    public void setBookmarkState(Object state) {
        if (!(state instanceof Map)) {
            return;
        }
        Map map = (Map)state;
        Boolean b = (Boolean)map.get("visible");
        if (b != null) {
            this.setVisible(b);
        }
    }

    public void addFormListener(FormListener listener) {
        this.form.addFormListener(listener);
    }

    public void removeFormListener(FormListener listener) {
        this.form.removeFormListener(listener);
    }

    public void revert(RequestContext context) {
        this.form.revert(context);
    }

    public boolean validate(RequestContext context) {
        return this.form.validate(context);
    }

    public Component getParent() {
        return this.parent;
    }

    public void setParent(Component parent) {
        this.parent = parent;
    }

    public void setNextView(String uri) {
        this.controller.setNextView(uri);
    }

    protected String getNextView() {
        return this.controller.getNextView();
    }

    public boolean isAutoValidate() {
        return this.autoValidate;
    }

    public void setAutoValidate(boolean autoValidate) {
        this.autoValidate = autoValidate;
    }

    public boolean isListeningTo(Map httpParams) {
        List list = this.dispatcher.findMatchingListeners(httpParams);
        return !list.isEmpty();
    }
}

