/*
 * Decompiled with CFR 0.152.
 */
package com.infobright.etl.model.datatype;

import com.infobright.etl.model.ValueConverter;
import com.infobright.etl.model.ValueConverterException;
import com.infobright.etl.model.datatype.AbstractColumnType;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;

class MediumintType
extends AbstractColumnType {
    private int data;

    MediumintType() {
    }

    public String getDataAsString() {
        return Integer.toString(this.data);
    }

    public void getData(ByteBuffer byteBuffer) {
        short lsbb = (short)(this.data & 0xFFFF);
        byte msb = (byte)(this.data >> 16 & 0xFF);
        if (byteBuffer.order() == ByteOrder.LITTLE_ENDIAN) {
            byteBuffer.putShort(lsbb);
            byteBuffer.put(msb);
        } else {
            byteBuffer.put(msb);
            byteBuffer.putShort(lsbb);
        }
    }

    public void setData(ByteBuffer byteBuffer) throws AbstractColumnType.InvalidDataException {
        byte msb;
        short lsbb;
        if (byteBuffer.order() == ByteOrder.LITTLE_ENDIAN) {
            lsbb = byteBuffer.getShort();
            msb = byteBuffer.get();
        } else {
            msb = byteBuffer.get();
            lsbb = byteBuffer.getShort();
        }
        this.data = lsbb & 0xFFFF | msb << 16;
    }

    public void setData(String string) {
        this.data = Integer.valueOf(string);
    }

    protected void zeroOutData() {
        this.data = 0;
    }

    public void setData(Object value, ValueConverter meta) throws ValueConverterException {
        if (value == null) {
            this.setIsNull(true);
        } else {
            Long val = meta.getInteger(value);
            if (val == null) {
                this.setIsNull(true);
            } else {
                this.setIsNull(false);
                if (val >= 0x800000L || val < -8388608L) {
                    throw new ValueConverterException("Value " + val + " out of range for MEDIUMINT");
                }
                this.data = val.intValue();
            }
        }
    }

    public final boolean isNeedsEnclosures() {
        return false;
    }
}

