/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.util;

import java.io.InputStream;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class VersionInfoUtils {
    private static final String VERSION_INFO_FILE = "com/amazonaws/sdk/versionInfo.properties";
    private static String version = null;
    private static Log log = LogFactory.getLog(VersionInfoUtils.class);

    public static String getVersion() {
        if (version == null) {
            VersionInfoUtils.initializeVersion();
        }
        return version;
    }

    private static void initializeVersion() {
        InputStream inputStream = VersionInfoUtils.class.getClassLoader().getResourceAsStream(VERSION_INFO_FILE);
        Properties versionInfoProperties = new Properties();
        try {
            if (inputStream == null) {
                throw new Exception("com/amazonaws/sdk/versionInfo.properties not found on classpath");
            }
            versionInfoProperties.load(inputStream);
            version = versionInfoProperties.getProperty("version");
        }
        catch (Exception e) {
            log.warn((Object)("Unable to load version information for the running SDK: " + e.getMessage()));
            version = "unknown-version";
        }
    }
}

