/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.autoscaling;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonServiceException;
import com.amazonaws.AmazonWebServiceClient;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.ClientConfiguration;
import com.amazonaws.Request;
import com.amazonaws.ResponseMetadata;
import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.QueryStringSigner;
import com.amazonaws.handlers.HandlerChainFactory;
import com.amazonaws.handlers.RequestHandler;
import com.amazonaws.http.DefaultErrorResponseHandler;
import com.amazonaws.http.HttpClient;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.http.HttpRequest;
import com.amazonaws.http.StaxResponseHandler;
import com.amazonaws.services.autoscaling.AmazonAutoScaling;
import com.amazonaws.services.autoscaling.model.CreateAutoScalingGroupRequest;
import com.amazonaws.services.autoscaling.model.CreateLaunchConfigurationRequest;
import com.amazonaws.services.autoscaling.model.CreateOrUpdateScalingTriggerRequest;
import com.amazonaws.services.autoscaling.model.DeleteAutoScalingGroupRequest;
import com.amazonaws.services.autoscaling.model.DeleteLaunchConfigurationRequest;
import com.amazonaws.services.autoscaling.model.DeleteTriggerRequest;
import com.amazonaws.services.autoscaling.model.DescribeAutoScalingGroupsRequest;
import com.amazonaws.services.autoscaling.model.DescribeAutoScalingGroupsResult;
import com.amazonaws.services.autoscaling.model.DescribeLaunchConfigurationsRequest;
import com.amazonaws.services.autoscaling.model.DescribeLaunchConfigurationsResult;
import com.amazonaws.services.autoscaling.model.DescribeScalingActivitiesRequest;
import com.amazonaws.services.autoscaling.model.DescribeScalingActivitiesResult;
import com.amazonaws.services.autoscaling.model.DescribeTriggersRequest;
import com.amazonaws.services.autoscaling.model.DescribeTriggersResult;
import com.amazonaws.services.autoscaling.model.SetDesiredCapacityRequest;
import com.amazonaws.services.autoscaling.model.TerminateInstanceInAutoScalingGroupRequest;
import com.amazonaws.services.autoscaling.model.TerminateInstanceInAutoScalingGroupResult;
import com.amazonaws.services.autoscaling.model.UpdateAutoScalingGroupRequest;
import com.amazonaws.services.autoscaling.model.transform.AlreadyExistsExceptionUnmarshaller;
import com.amazonaws.services.autoscaling.model.transform.CreateAutoScalingGroupRequestMarshaller;
import com.amazonaws.services.autoscaling.model.transform.CreateLaunchConfigurationRequestMarshaller;
import com.amazonaws.services.autoscaling.model.transform.CreateOrUpdateScalingTriggerRequestMarshaller;
import com.amazonaws.services.autoscaling.model.transform.DeleteAutoScalingGroupRequestMarshaller;
import com.amazonaws.services.autoscaling.model.transform.DeleteLaunchConfigurationRequestMarshaller;
import com.amazonaws.services.autoscaling.model.transform.DeleteTriggerRequestMarshaller;
import com.amazonaws.services.autoscaling.model.transform.DescribeAutoScalingGroupsRequestMarshaller;
import com.amazonaws.services.autoscaling.model.transform.DescribeAutoScalingGroupsResultStaxUnmarshaller;
import com.amazonaws.services.autoscaling.model.transform.DescribeLaunchConfigurationsRequestMarshaller;
import com.amazonaws.services.autoscaling.model.transform.DescribeLaunchConfigurationsResultStaxUnmarshaller;
import com.amazonaws.services.autoscaling.model.transform.DescribeScalingActivitiesRequestMarshaller;
import com.amazonaws.services.autoscaling.model.transform.DescribeScalingActivitiesResultStaxUnmarshaller;
import com.amazonaws.services.autoscaling.model.transform.DescribeTriggersRequestMarshaller;
import com.amazonaws.services.autoscaling.model.transform.DescribeTriggersResultStaxUnmarshaller;
import com.amazonaws.services.autoscaling.model.transform.InvalidNextTokenExceptionUnmarshaller;
import com.amazonaws.services.autoscaling.model.transform.LimitExceededExceptionUnmarshaller;
import com.amazonaws.services.autoscaling.model.transform.ResourceInUseExceptionUnmarshaller;
import com.amazonaws.services.autoscaling.model.transform.ScalingActivityInProgressExceptionUnmarshaller;
import com.amazonaws.services.autoscaling.model.transform.SetDesiredCapacityRequestMarshaller;
import com.amazonaws.services.autoscaling.model.transform.TerminateInstanceInAutoScalingGroupRequestMarshaller;
import com.amazonaws.services.autoscaling.model.transform.TerminateInstanceInAutoScalingGroupResultStaxUnmarshaller;
import com.amazonaws.services.autoscaling.model.transform.UpdateAutoScalingGroupRequestMarshaller;
import com.amazonaws.transform.StandardErrorUnmarshaller;
import com.amazonaws.transform.StaxUnmarshallerContext;
import com.amazonaws.transform.Unmarshaller;
import java.security.SignatureException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AmazonAutoScalingClient
extends AmazonWebServiceClient
implements AmazonAutoScaling {
    private AWSCredentials awsCredentials;
    protected final List<Unmarshaller<AmazonServiceException, Node>> exceptionUnmarshallers;
    protected final HttpClient client;
    private List<RequestHandler> requestHandlers = new ArrayList<RequestHandler>();
    private QueryStringSigner signer;

    public AmazonAutoScalingClient(AWSCredentials awsCredentials) {
        this(awsCredentials, new ClientConfiguration());
    }

    public AmazonAutoScalingClient(AWSCredentials awsCredentials, ClientConfiguration clientConfiguration) {
        super(clientConfiguration);
        this.awsCredentials = awsCredentials;
        this.exceptionUnmarshallers = new ArrayList<Unmarshaller<AmazonServiceException, Node>>();
        this.exceptionUnmarshallers.add(new AlreadyExistsExceptionUnmarshaller());
        this.exceptionUnmarshallers.add(new ScalingActivityInProgressExceptionUnmarshaller());
        this.exceptionUnmarshallers.add(new InvalidNextTokenExceptionUnmarshaller());
        this.exceptionUnmarshallers.add(new LimitExceededExceptionUnmarshaller());
        this.exceptionUnmarshallers.add(new ResourceInUseExceptionUnmarshaller());
        this.exceptionUnmarshallers.add(new StandardErrorUnmarshaller());
        this.setEndpoint("autoscaling.amazonaws.com");
        this.signer = new QueryStringSigner(awsCredentials);
        this.requestHandlers = new HandlerChainFactory().newRequestHandlerChain("/com/amazonaws/services/autoscaling/request.handlers");
        this.client = new HttpClient(clientConfiguration);
    }

    @Override
    public void deleteLaunchConfiguration(DeleteLaunchConfigurationRequest deleteLaunchConfigurationRequest) throws AmazonServiceException, AmazonClientException {
        Request<DeleteLaunchConfigurationRequest> request = new DeleteLaunchConfigurationRequestMarshaller().marshall(deleteLaunchConfigurationRequest);
        this.invoke(request, null);
    }

    @Override
    public DescribeTriggersResult describeTriggers(DescribeTriggersRequest describeTriggersRequest) throws AmazonServiceException, AmazonClientException {
        Request<DescribeTriggersRequest> request = new DescribeTriggersRequestMarshaller().marshall(describeTriggersRequest);
        return this.invoke(request, new DescribeTriggersResultStaxUnmarshaller());
    }

    @Override
    public void updateAutoScalingGroup(UpdateAutoScalingGroupRequest updateAutoScalingGroupRequest) throws AmazonServiceException, AmazonClientException {
        Request<UpdateAutoScalingGroupRequest> request = new UpdateAutoScalingGroupRequestMarshaller().marshall(updateAutoScalingGroupRequest);
        this.invoke(request, null);
    }

    @Override
    public void createAutoScalingGroup(CreateAutoScalingGroupRequest createAutoScalingGroupRequest) throws AmazonServiceException, AmazonClientException {
        Request<CreateAutoScalingGroupRequest> request = new CreateAutoScalingGroupRequestMarshaller().marshall(createAutoScalingGroupRequest);
        this.invoke(request, null);
    }

    @Override
    public void deleteTrigger(DeleteTriggerRequest deleteTriggerRequest) throws AmazonServiceException, AmazonClientException {
        Request<DeleteTriggerRequest> request = new DeleteTriggerRequestMarshaller().marshall(deleteTriggerRequest);
        this.invoke(request, null);
    }

    @Override
    public TerminateInstanceInAutoScalingGroupResult terminateInstanceInAutoScalingGroup(TerminateInstanceInAutoScalingGroupRequest terminateInstanceInAutoScalingGroupRequest) throws AmazonServiceException, AmazonClientException {
        Request<TerminateInstanceInAutoScalingGroupRequest> request = new TerminateInstanceInAutoScalingGroupRequestMarshaller().marshall(terminateInstanceInAutoScalingGroupRequest);
        return this.invoke(request, new TerminateInstanceInAutoScalingGroupResultStaxUnmarshaller());
    }

    @Override
    public void createOrUpdateScalingTrigger(CreateOrUpdateScalingTriggerRequest createOrUpdateScalingTriggerRequest) throws AmazonServiceException, AmazonClientException {
        Request<CreateOrUpdateScalingTriggerRequest> request = new CreateOrUpdateScalingTriggerRequestMarshaller().marshall(createOrUpdateScalingTriggerRequest);
        this.invoke(request, null);
    }

    @Override
    public DescribeAutoScalingGroupsResult describeAutoScalingGroups(DescribeAutoScalingGroupsRequest describeAutoScalingGroupsRequest) throws AmazonServiceException, AmazonClientException {
        Request<DescribeAutoScalingGroupsRequest> request = new DescribeAutoScalingGroupsRequestMarshaller().marshall(describeAutoScalingGroupsRequest);
        return this.invoke(request, new DescribeAutoScalingGroupsResultStaxUnmarshaller());
    }

    @Override
    public void createLaunchConfiguration(CreateLaunchConfigurationRequest createLaunchConfigurationRequest) throws AmazonServiceException, AmazonClientException {
        Request<CreateLaunchConfigurationRequest> request = new CreateLaunchConfigurationRequestMarshaller().marshall(createLaunchConfigurationRequest);
        this.invoke(request, null);
    }

    @Override
    public DescribeLaunchConfigurationsResult describeLaunchConfigurations(DescribeLaunchConfigurationsRequest describeLaunchConfigurationsRequest) throws AmazonServiceException, AmazonClientException {
        Request<DescribeLaunchConfigurationsRequest> request = new DescribeLaunchConfigurationsRequestMarshaller().marshall(describeLaunchConfigurationsRequest);
        return this.invoke(request, new DescribeLaunchConfigurationsResultStaxUnmarshaller());
    }

    @Override
    public DescribeScalingActivitiesResult describeScalingActivities(DescribeScalingActivitiesRequest describeScalingActivitiesRequest) throws AmazonServiceException, AmazonClientException {
        Request<DescribeScalingActivitiesRequest> request = new DescribeScalingActivitiesRequestMarshaller().marshall(describeScalingActivitiesRequest);
        return this.invoke(request, new DescribeScalingActivitiesResultStaxUnmarshaller());
    }

    @Override
    public void setDesiredCapacity(SetDesiredCapacityRequest setDesiredCapacityRequest) throws AmazonServiceException, AmazonClientException {
        Request<SetDesiredCapacityRequest> request = new SetDesiredCapacityRequestMarshaller().marshall(setDesiredCapacityRequest);
        this.invoke(request, null);
    }

    @Override
    public void deleteAutoScalingGroup(DeleteAutoScalingGroupRequest deleteAutoScalingGroupRequest) throws AmazonServiceException, AmazonClientException {
        Request<DeleteAutoScalingGroupRequest> request = new DeleteAutoScalingGroupRequestMarshaller().marshall(deleteAutoScalingGroupRequest);
        this.invoke(request, null);
    }

    @Override
    public DescribeAutoScalingGroupsResult describeAutoScalingGroups() throws AmazonServiceException, AmazonClientException {
        return this.describeAutoScalingGroups(new DescribeAutoScalingGroupsRequest());
    }

    @Override
    public DescribeLaunchConfigurationsResult describeLaunchConfigurations() throws AmazonServiceException, AmazonClientException {
        return this.describeLaunchConfigurations(new DescribeLaunchConfigurationsRequest());
    }

    @Override
    public ResponseMetadata getCachedResponseMetadata(AmazonWebServiceRequest request) {
        return this.client.getResponseMetadataForRequest(request);
    }

    private <X, Y extends AmazonWebServiceRequest> X invoke(Request<Y> request, Unmarshaller<X, StaxUnmarshallerContext> unmarshaller) {
        request.setEndpoint(this.endpoint);
        for (Map.Entry<String, String> entry : request.getOriginalRequest().copyPrivateRequestParameters().entrySet()) {
            request.addParameter(entry.getKey(), entry.getValue());
        }
        if (this.requestHandlers != null) {
            for (RequestHandler requestHandler : this.requestHandlers) {
                request = requestHandler.handleRequest(request);
            }
        }
        try {
            this.signer.sign(request);
        }
        catch (SignatureException e) {
            throw new AmazonServiceException("Unable to sign request", e);
        }
        HttpRequest httpRequest = this.convertToHttpRequest(request, HttpMethodName.POST);
        StaxResponseHandler<X> responseHandler = new StaxResponseHandler<X>(unmarshaller);
        DefaultErrorResponseHandler errorResponseHandler = new DefaultErrorResponseHandler(this.exceptionUnmarshallers);
        return (X)this.client.execute(httpRequest, responseHandler, errorResponseHandler);
    }
}

