/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.mongo.wrapper.collection;

import com.mongodb.AggregationOutput;
import com.mongodb.BasicDBObject;
import com.mongodb.DBCollection;
import com.mongodb.DBCursor;
import com.mongodb.DBObject;
import com.mongodb.WriteResult;
import java.util.List;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.mongo.wrapper.collection.MongoCollectionWrapper;
import org.pentaho.mongo.wrapper.cursor.DefaultCursorWrapper;
import org.pentaho.mongo.wrapper.cursor.MongoCursorWrapper;

public class DefaultMongoCollectionWrapper
implements MongoCollectionWrapper {
    private final DBCollection collection;

    public DefaultMongoCollectionWrapper(DBCollection collection) {
        this.collection = collection;
    }

    @Override
    public MongoCursorWrapper find(DBObject dbObject, DBObject dbObject2) throws KettleException {
        return this.wrap(this.collection.find(dbObject, dbObject2));
    }

    @Override
    public AggregationOutput aggregate(DBObject firstP, DBObject[] remainder) throws KettleException {
        return this.collection.aggregate(firstP, remainder);
    }

    @Override
    public MongoCursorWrapper find() throws KettleException {
        return this.wrap(this.collection.find());
    }

    @Override
    public void drop() throws KettleException {
        this.collection.drop();
    }

    @Override
    public WriteResult update(DBObject updateQuery, DBObject insertUpdate, boolean upsert, boolean multi) throws KettleException {
        return this.collection.update(updateQuery, insertUpdate, upsert, multi);
    }

    @Override
    public WriteResult insert(List<DBObject> m_batch) throws KettleException {
        return this.collection.insert(m_batch);
    }

    @Override
    public MongoCursorWrapper find(DBObject query) throws KettleException {
        return this.wrap(this.collection.find(query));
    }

    @Override
    public void dropIndex(BasicDBObject mongoIndex) throws KettleException {
        this.collection.dropIndex((DBObject)mongoIndex);
    }

    @Override
    public void createIndex(BasicDBObject mongoIndex) throws KettleException {
        this.collection.createIndex((DBObject)mongoIndex);
    }

    @Override
    public WriteResult save(DBObject toTry) throws KettleException {
        return this.collection.save(toTry);
    }

    protected MongoCursorWrapper wrap(DBCursor cursor) {
        return new DefaultCursorWrapper(cursor);
    }
}

