/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.mongo;

import javax.security.auth.login.LoginContext;
import javax.security.auth.login.LoginException;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.mongo.KerberosUtil;

public class KettleKerberosHelper {
    private static final String PENTAHO_JAAS_AUTH_MODE = "PENTAHO_JAAS_AUTH_MODE";
    private static final String PENTAHO_JAAS_KEYTAB_FILE = "PENTAHO_JAAS_KEYTAB_FILE";

    private static KerberosUtil.JaasAuthenticationMode lookupLoginAuthMode(VariableSpace varSpace) {
        KerberosUtil.JaasAuthenticationMode authMode;
        try {
            authMode = KerberosUtil.JaasAuthenticationMode.valueOf(varSpace.getVariable(PENTAHO_JAAS_AUTH_MODE));
        }
        catch (Exception ex) {
            authMode = KerberosUtil.JaasAuthenticationMode.KERBEROS_USER;
        }
        return authMode;
    }

    private static String lookupKeytabFile(VariableSpace varSpace) {
        return varSpace.getVariable(PENTAHO_JAAS_KEYTAB_FILE);
    }

    public static LoginContext login(VariableSpace varSpace, String principal) throws KettleException {
        try {
            KerberosUtil.JaasAuthenticationMode authMode = KettleKerberosHelper.lookupLoginAuthMode(varSpace);
            String keytabFile = KettleKerberosHelper.lookupKeytabFile(varSpace);
            return KerberosUtil.loginAs(authMode, principal, keytabFile);
        }
        catch (LoginException ex) {
            throw new KettleException("Unable to authenticate as '" + principal + "'", (Throwable)ex);
        }
    }
}

