/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.mongodboutput;

import com.mongodb.CommandResult;
import com.mongodb.DBObject;
import com.mongodb.MongoException;
import com.mongodb.ServerAddress;
import com.mongodb.WriteResult;
import java.net.SocketTimeoutException;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.trans.Trans;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.BaseStep;
import org.pentaho.di.trans.step.StepDataInterface;
import org.pentaho.di.trans.step.StepInterface;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.trans.steps.mongodboutput.MongoDbOutputData;
import org.pentaho.di.trans.steps.mongodboutput.MongoDbOutputMeta;
import org.pentaho.mongo.wrapper.MongoClientWrapperFactory;

public class MongoDbOutput
extends BaseStep
implements StepInterface {
    private static Class<?> PKG = MongoDbOutputMeta.class;
    protected MongoDbOutputMeta m_meta;
    protected MongoDbOutputData m_data;
    protected MongoDbOutputData.MongoTopLevel m_mongoTopLevelStructure = MongoDbOutputData.MongoTopLevel.INCONSISTENT;
    protected int m_batchInsertSize = 100;
    protected List<DBObject> m_batch;
    protected List<Object[]> m_batchRows;
    protected int m_writeRetries = 5;
    protected int m_writeRetryDelay = 10;

    public MongoDbOutput(StepMeta stepMeta, StepDataInterface stepDataInterface, int copyNr, TransMeta transMeta, Trans trans) {
        super(stepMeta, stepDataInterface, copyNr, transMeta, trans);
    }

    public boolean processRow(StepMetaInterface smi, StepDataInterface sdi) throws KettleException {
        Object[] row = this.getRow();
        if (row == null) {
            List<MongoDbOutputMeta.MongoIndex> indexes;
            if (this.m_batch != null && this.m_batch.size() > 0) {
                this.doBatch();
            }
            if ((indexes = this.m_meta.getMongoIndexes()) != null && indexes.size() > 0) {
                this.logBasic(BaseMessages.getString(PKG, (String)"MongoDbOutput.Messages.ApplyingIndexOpps", (String[])new String[0]));
                this.m_data.applyIndexes(indexes, this.log, this.m_meta.getTruncate());
            }
            this.disconnect();
            this.setOutputDone();
            return false;
        }
        if (this.first) {
            this.first = false;
            this.m_batchInsertSize = 100;
            String batchInsert = this.environmentSubstitute(this.m_meta.getBatchInsertSize());
            if (!Const.isEmpty((String)batchInsert)) {
                this.m_batchInsertSize = Integer.parseInt(batchInsert);
            }
            this.m_batch = new ArrayList<DBObject>(this.m_batchInsertSize);
            this.m_batchRows = new ArrayList<Object[]>();
            this.m_data.setOutputRowMeta(this.getInputRowMeta());
            this.m_data.m_hasTopLevelJSONDocInsert = MongoDbOutputData.scanForInsertTopLevelJSONDoc(this.m_meta.m_mongoFields);
            RowMetaInterface rmi = this.getInputRowMeta();
            List<MongoDbOutputMeta.MongoField> mongoFields = this.m_meta.getMongoFields();
            this.checkInputFieldsMatch(rmi, mongoFields);
            this.m_data.setMongoFields(this.m_meta.getMongoFields());
            this.m_data.init((VariableSpace)this);
            if (this.m_meta.getTruncate()) {
                try {
                    this.logBasic(BaseMessages.getString(PKG, (String)"MongoDbOutput.Messages.TruncatingCollection", (String[])new String[0]));
                    this.m_data.getCollection().drop();
                    String collection = this.environmentSubstitute(this.m_meta.getCollection());
                    this.m_data.createCollection(this.m_meta.getDbName(), collection);
                    this.m_data.setCollection(this.m_data.getConnection().getCollection(this.m_meta.getDbName(), collection));
                }
                catch (Exception m) {
                    this.disconnect();
                    throw new KettleException(m.getMessage(), (Throwable)m);
                }
            }
        }
        if (!this.isStopped()) {
            if (this.m_meta.getUpdate()) {
                DBObject updateQuery = MongoDbOutputData.getQueryObject(this.m_data.m_userFields, this.getInputRowMeta(), row, (VariableSpace)this, this.m_mongoTopLevelStructure);
                if (this.log.isDebug()) {
                    this.logDebug(BaseMessages.getString(PKG, (String)"MongoDbOutput.Messages.Debug.QueryForUpsert", (Object[])new Object[]{updateQuery}));
                }
                if (updateQuery != null) {
                    DBObject insertUpdate = null;
                    if (!this.m_meta.getModifierUpdate()) {
                        insertUpdate = MongoDbOutputData.kettleRowToMongo(this.m_data.m_userFields, this.getInputRowMeta(), row, (VariableSpace)this, this.m_mongoTopLevelStructure, this.m_data.m_hasTopLevelJSONDocInsert);
                        if (this.log.isDebug()) {
                            this.logDebug(BaseMessages.getString(PKG, (String)"MongoDbOutput.Messages.Debug.InsertUpsertObject", (Object[])new Object[]{insertUpdate}));
                        }
                    } else {
                        insertUpdate = this.m_data.getModifierUpdateObject(this.m_data.m_userFields, this.getInputRowMeta(), row, (VariableSpace)this, this.m_mongoTopLevelStructure);
                        if (this.log.isDebug()) {
                            this.logDebug(BaseMessages.getString(PKG, (String)"MongoDbOutput.Messages.Debug.ModifierUpdateObject", (Object[])new Object[]{insertUpdate}));
                        }
                    }
                    if (insertUpdate != null) {
                        this.commitUpdate(updateQuery, insertUpdate, row);
                    }
                }
            } else {
                DBObject mongoInsert = MongoDbOutputData.kettleRowToMongo(this.m_data.m_userFields, this.getInputRowMeta(), row, (VariableSpace)this, this.m_mongoTopLevelStructure, this.m_data.m_hasTopLevelJSONDocInsert);
                if (mongoInsert != null) {
                    this.m_batch.add(mongoInsert);
                    this.m_batchRows.add(row);
                }
                if (this.m_batch.size() == this.m_batchInsertSize) {
                    this.logDetailed(BaseMessages.getString(PKG, (String)"MongoDbOutput.Messages.CommitingABatch", (String[])new String[0]));
                    this.doBatch();
                }
            }
        }
        return true;
    }

    protected void commitUpdate(DBObject updateQuery, DBObject insertUpdate, Object[] row) throws KettleException {
        int retrys = 0;
        MongoException lastEx = null;
        while (retrys <= this.m_writeRetries && !this.isStopped()) {
            CommandResult cmd;
            block9: {
                WriteResult result = null;
                cmd = null;
                try {
                    result = this.m_data.getCollection().update(updateQuery, insertUpdate, this.m_meta.getUpsert(), this.m_meta.getMulti());
                    cmd = result.getLastError();
                    if (cmd != null && !cmd.ok()) {
                        String message = cmd.getErrorMessage();
                        this.logError(BaseMessages.getString(PKG, (String)"MongoDbOutput.Messages.Error.MongoReported", (String[])new String[]{message}));
                        cmd.throwOnError();
                    }
                }
                catch (MongoException me) {
                    lastEx = me;
                    if (++retrys > this.m_writeRetries) break block9;
                    this.logError(BaseMessages.getString(PKG, (String)"MongoDbOutput.Messages.Error.ErrorWritingToMongo", (String[])new String[]{me.toString()}));
                    this.logBasic(BaseMessages.getString(PKG, (String)"MongoDbOutput.Messages.Message.Retry", (Object[])new Object[]{this.m_writeRetryDelay}));
                    try {
                        Thread.sleep(this.m_writeRetryDelay * 1000);
                    }
                    catch (InterruptedException e) {
                        // empty catch block
                    }
                }
            }
            if (cmd == null || !cmd.ok()) continue;
            break;
        }
        if ((retrys > this.m_writeRetries || this.isStopped()) && lastEx != null) {
            if (this.getStepMeta().isDoingErrorHandling()) {
                this.putError(this.getInputRowMeta(), row, 1L, lastEx.getMessage(), "", "MongoDbOutput");
            } else {
                throw new KettleException((Throwable)lastEx);
            }
        }
    }

    protected CommandResult batchRetryUsingSave(boolean lastRetry) throws MongoException, KettleException {
        WriteResult result = null;
        CommandResult cmd = null;
        int count = 0;
        this.logBasic(BaseMessages.getString(PKG, (String)"MongoDbOutput.Messages.CurrentBatchSize", (Object[])new Object[]{this.m_batch.size()}));
        int len = this.m_batch.size();
        for (int i = 0; i < len; ++i) {
            DBObject toTry = this.m_batch.get(i);
            Object[] correspondingRow = this.m_batchRows.get(i);
            try {
                result = this.m_data.getCollection().save(toTry);
                cmd = result.getLastError();
                if (cmd != null && !cmd.ok()) {
                    String message = cmd.getErrorMessage();
                    this.logError(BaseMessages.getString(PKG, (String)"MongoDbOutput.Messages.Error.MongoReported", (String[])new String[]{message}));
                    cmd.throwOnError();
                }
                ++count;
                continue;
            }
            catch (MongoException ex) {
                if (!lastRetry) {
                    this.logBasic(BaseMessages.getString(PKG, (String)"MongoDbOutput.Messages.SuccessfullySavedXDocuments", (Object[])new Object[]{count}));
                    this.m_batch = MongoDbOutput.copyExceptFirst(count, this.m_batch);
                    this.m_batchRows = MongoDbOutput.copyExceptFirst(count, this.m_batchRows);
                    throw ex;
                }
                if (this.getStepMeta().isDoingErrorHandling()) {
                    this.putError(this.getInputRowMeta(), correspondingRow, 1L, ex.getMessage(), "", "MongoDbOutput");
                    continue;
                }
                this.m_batch = MongoDbOutput.copyExceptFirst(i + 1, this.m_batch);
                this.m_batchRows = MongoDbOutput.copyExceptFirst(i + 1, this.m_batchRows);
                throw ex;
            }
        }
        this.m_batch.clear();
        this.m_batchRows.clear();
        this.logBasic(BaseMessages.getString(PKG, (String)"MongoDbOutput.Messages.SuccessfullySavedXDocuments", (Object[])new Object[]{count}));
        return cmd;
    }

    private static <T> List<T> copyExceptFirst(int amount, List<T> list) {
        return new ArrayList<T>(list.subList(amount, list.size()));
    }

    protected void doBatch() throws KettleException {
        int retries = 0;
        MongoException lastEx = null;
        while (retries <= this.m_writeRetries && !this.isStopped()) {
            ServerAddress s;
            CommandResult cmd;
            block12: {
                WriteResult result = null;
                cmd = null;
                try {
                    if (retries == 0) {
                        result = this.m_data.getCollection().insert(this.m_batch);
                        cmd = result.getLastError();
                        if (cmd != null && !cmd.ok()) {
                            String message = cmd.getErrorMessage();
                            this.logError(BaseMessages.getString(PKG, (String)"MongoDbOutput.Messages.Error.MongoReported", (String[])new String[]{message}));
                            cmd.throwOnError();
                        }
                    } else {
                        this.logBasic(BaseMessages.getString(PKG, (String)"MongoDbOutput.Messages.SavingIndividualDocsInCurrentBatch", (String[])new String[0]));
                        cmd = this.batchRetryUsingSave(retries == this.m_writeRetries);
                    }
                }
                catch (MongoException me) {
                    boolean shouldNotBeAvoided;
                    boolean bl = shouldNotBeAvoided = !MongoDbOutput.isTimeoutException(me) && retries == 0;
                    if (shouldNotBeAvoided) {
                        lastEx = me;
                    }
                    if (++retries > this.m_writeRetries) break block12;
                    if (shouldNotBeAvoided) {
                        this.logError(BaseMessages.getString(PKG, (String)"MongoDbOutput.Messages.Error.ErrorWritingToMongo", (String[])new String[]{me.toString()}));
                        this.logBasic(BaseMessages.getString(PKG, (String)"MongoDbOutput.Messages.Message.Retry", (Object[])new Object[]{this.m_writeRetryDelay}));
                    }
                    try {
                        Thread.sleep(this.m_writeRetryDelay * 1000);
                    }
                    catch (InterruptedException e) {
                        // empty catch block
                    }
                }
            }
            if (cmd != null && (s = cmd.getServerUsed()) != null) {
                this.logDetailed(BaseMessages.getString(PKG, (String)"MongoDbOutput.Messages.WroteBatchToServer", (String[])new String[]{s.toString()}));
            }
            if (cmd == null || !cmd.ok()) continue;
            break;
        }
        if ((retries > this.m_writeRetries || this.isStopped()) && lastEx != null) {
            throw new KettleException(lastEx);
        }
        this.m_batch.clear();
        this.m_batchRows.clear();
    }

    private static boolean isTimeoutException(MongoException me) {
        return me instanceof MongoException.Network && me.getCause() instanceof SocketTimeoutException;
    }

    public boolean init(StepMetaInterface stepMetaInterface, StepDataInterface stepDataInterface) {
        if (super.init(stepMetaInterface, stepDataInterface)) {
            this.m_meta = (MongoDbOutputMeta)stepMetaInterface;
            this.m_data = (MongoDbOutputData)stepDataInterface;
            if (!Const.isEmpty((String)this.m_meta.getWriteRetries())) {
                try {
                    this.m_writeRetries = Integer.parseInt(this.m_meta.getWriteRetries());
                }
                catch (NumberFormatException ex) {
                    this.m_writeRetries = 5;
                }
            }
            if (!Const.isEmpty((String)this.m_meta.getWriteRetryDelay())) {
                try {
                    this.m_writeRetryDelay = Integer.parseInt(this.m_meta.getWriteRetryDelay());
                }
                catch (NumberFormatException ex) {
                    this.m_writeRetryDelay = 10;
                }
            }
            String hostname = this.environmentSubstitute(this.m_meta.getHostnames());
            int port = Const.toInt((String)this.environmentSubstitute(this.m_meta.getPort()), (int)27017);
            String db = this.environmentSubstitute(this.m_meta.getDbName());
            String collection = this.environmentSubstitute(this.m_meta.getCollection());
            try {
                if (Const.isEmpty((String)db)) {
                    throw new Exception(BaseMessages.getString(PKG, (String)"MongoDbOutput.Messages.Error.NoDBSpecified", (String[])new String[0]));
                }
                if (Const.isEmpty((String)collection)) {
                    throw new Exception(BaseMessages.getString(PKG, (String)"MongoDbOutput.Messages.Error.NoCollectionSpecified", (String[])new String[0]));
                }
                if (!Const.isEmpty((String)this.m_meta.getAuthenticationUser())) {
                    String authInfo = this.m_meta.getUseKerberosAuthentication() ? BaseMessages.getString(PKG, (String)"MongoDbOutput.Message.KerberosAuthentication", (String[])new String[]{this.environmentSubstitute(this.m_meta.getAuthenticationUser())}) : BaseMessages.getString(PKG, (String)"MongoDbOutput.Message.NormalAuthentication", (String[])new String[]{this.environmentSubstitute(this.m_meta.getAuthenticationUser())});
                    this.logBasic(authInfo);
                }
                this.m_data.setConnection(MongoClientWrapperFactory.createMongoClientWrapper(this.m_meta, (VariableSpace)this, this.log));
                if (Const.isEmpty((String)collection)) {
                    throw new KettleException(BaseMessages.getString(PKG, (String)"MongoDbOutput.Messages.Error.NoCollectionSpecified", (String[])new String[0]));
                }
                this.m_data.createCollection(db, collection);
                this.m_data.setCollection(this.m_data.getConnection().getCollection(db, collection));
                try {
                    this.m_mongoTopLevelStructure = MongoDbOutputData.checkTopLevelConsistency(this.m_meta.m_mongoFields, (VariableSpace)this);
                    if (this.m_mongoTopLevelStructure == MongoDbOutputData.MongoTopLevel.INCONSISTENT) {
                        this.logError(BaseMessages.getString(PKG, (String)"MongoDbOutput.Messages.Error.InconsistentMongoTopLevel", (String[])new String[0]));
                        return false;
                    }
                }
                catch (KettleException e) {
                    this.logError(e.getMessage());
                    return false;
                }
                return true;
            }
            catch (UnknownHostException ex) {
                this.logError(BaseMessages.getString(PKG, (String)"MongoDbOutput.Messages.Error.UnknownHost", (String[])new String[]{hostname}), ex);
                return false;
            }
            catch (Exception e) {
                this.logError(BaseMessages.getString(PKG, (String)"MongoDbOutput.Messages.Error.ProblemConnecting", (String[])new String[]{hostname, "" + port}), e);
                return false;
            }
        }
        return false;
    }

    protected void disconnect() {
        if (this.m_data != null) {
            try {
                this.m_data.getConnection().dispose();
            }
            catch (KettleException e) {
                this.log.logError(e.getMessage());
            }
        }
    }

    public void dispose(StepMetaInterface smi, StepDataInterface sdi) {
        if (this.m_data != null) {
            try {
                this.m_data.getConnection().dispose();
            }
            catch (KettleException e) {
                this.log.logError(e.getMessage());
            }
        }
        super.dispose(smi, sdi);
    }

    final void checkInputFieldsMatch(RowMetaInterface rmi, List<MongoDbOutputMeta.MongoField> mongoFields) throws KettleException {
        HashSet<String> expected = new HashSet<String>(mongoFields.size(), 1.0f);
        HashSet<String> actual = new HashSet<String>(rmi.getFieldNames().length, 1.0f);
        for (MongoDbOutputMeta.MongoField field : mongoFields) {
            String mongoMatch = this.environmentSubstitute(field.m_incomingFieldName);
            expected.add(mongoMatch);
        }
        for (int i = 0; i < rmi.size(); ++i) {
            String metaFieldName = rmi.getValueMeta(i).getName();
            actual.add(metaFieldName);
        }
        if (!actual.containsAll(expected)) {
            expected.removeAll(actual);
            StringBuffer b = new StringBuffer();
            for (String name : expected) {
                b.append("'").append(name).append("', ");
            }
            throw new KettleException(BaseMessages.getString(PKG, (String)"MongoDbOutput.Messages.MongoField.Error.FieldsNotFoundInMetadata", (String[])new String[]{b.toString()}));
        }
        boolean found = actual.removeAll(expected);
        if (!found) {
            throw new KettleException(BaseMessages.getString(PKG, (String)"MongoDbOutput.Messages.Error.NotInsertingAnyFields", (String[])new String[0]));
        }
        if (!actual.isEmpty()) {
            StringBuffer b = new StringBuffer();
            for (String name : actual) {
                b.append("'").append(name).append("', ");
            }
            this.logBasic(BaseMessages.getString(PKG, (String)"MongoDbOutput.Messages.FieldsNotToBeInserted", (String[])new String[]{b.toString()}));
        }
    }
}

