/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.contrib.util.typedbytes;

import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.contrib.util.typedbytes.Type;
import org.apache.hadoop.hive.contrib.util.typedbytes.TypedBytesWritableInput;
import org.apache.hadoop.hive.contrib.util.typedbytes.TypedBytesWritableOutput;
import org.apache.hadoop.hive.ql.exec.RecordReader;
import org.apache.hadoop.hive.ql.io.NonSyncDataOutputBuffer;
import org.apache.hadoop.hive.serde2.io.ByteWritable;
import org.apache.hadoop.hive.serde2.io.DoubleWritable;
import org.apache.hadoop.hive.serde2.io.ShortWritable;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspectorConverters;
import org.apache.hadoop.hive.serde2.objectinspector.PrimitiveObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.PrimitiveObjectInspectorFactory;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.PrimitiveObjectInspectorUtils;
import org.apache.hadoop.io.BooleanWritable;
import org.apache.hadoop.io.BytesWritable;
import org.apache.hadoop.io.FloatWritable;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.Writable;

public class TypedBytesRecordReader
implements RecordReader {
    private DataInputStream din;
    private TypedBytesWritableInput tbIn;
    private NonSyncDataOutputBuffer barrStr = new NonSyncDataOutputBuffer();
    private TypedBytesWritableOutput tbOut;
    private ArrayList<Writable> row = new ArrayList(0);
    private ArrayList<String> rowTypeName = new ArrayList(0);
    private List<String> columnTypes;
    private ArrayList<ObjectInspector> srcOIns = new ArrayList();
    private ArrayList<ObjectInspector> dstOIns = new ArrayList();
    private ArrayList<ObjectInspectorConverters.Converter> converters = new ArrayList();
    private static Map<Type, String> typedBytesToTypeName = new HashMap<Type, String>();

    public void initialize(InputStream in, Configuration conf, Properties tbl) throws IOException {
        this.din = new DataInputStream(in);
        this.tbIn = new TypedBytesWritableInput(this.din);
        this.tbOut = new TypedBytesWritableOutput((DataOutput)this.barrStr);
        String columnTypeProperty = tbl.getProperty("columns.types");
        this.columnTypes = Arrays.asList(columnTypeProperty.split(","));
        for (String columnType : this.columnTypes) {
            PrimitiveObjectInspectorUtils.PrimitiveTypeEntry dstTypeEntry = PrimitiveObjectInspectorUtils.getTypeEntryFromTypeName((String)columnType);
            this.dstOIns.add((ObjectInspector)PrimitiveObjectInspectorFactory.getPrimitiveWritableObjectInspector((PrimitiveObjectInspector.PrimitiveCategory)dstTypeEntry.primitiveCategory));
        }
    }

    public Writable createRow() throws IOException {
        BytesWritable retWrit = new BytesWritable();
        return retWrit;
    }

    private Writable allocateWritable(Type type) {
        switch (type) {
            case BYTE: {
                return new ByteWritable();
            }
            case BOOL: {
                return new BooleanWritable();
            }
            case INT: {
                return new IntWritable();
            }
            case SHORT: {
                return new ShortWritable();
            }
            case LONG: {
                return new LongWritable();
            }
            case FLOAT: {
                return new FloatWritable();
            }
            case DOUBLE: {
                return new DoubleWritable();
            }
            case STRING: {
                return new Text();
            }
        }
        assert (false);
        return null;
    }

    public int next(Writable data) throws IOException {
        int pos = 0;
        this.barrStr.reset();
        Type type;
        while ((type = this.tbIn.readTypeCode()) != null) {
            if (type == Type.ENDOFRECORD) {
                this.tbOut.writeEndOfRecord();
                if (this.barrStr.getLength() > 0) {
                    ((BytesWritable)data).set(this.barrStr.getData(), 0, this.barrStr.getLength());
                }
                return this.barrStr.getLength();
            }
            if (pos >= this.row.size()) {
                Writable wrt = this.allocateWritable(type);
                assert (pos == this.row.size());
                assert (pos == this.rowTypeName.size());
                this.row.add(wrt);
                this.rowTypeName.add(type.name());
                String typeName = typedBytesToTypeName.get((Object)type);
                PrimitiveObjectInspectorUtils.PrimitiveTypeEntry srcTypeEntry = PrimitiveObjectInspectorUtils.getTypeEntryFromTypeName((String)typeName);
                this.srcOIns.add((ObjectInspector)PrimitiveObjectInspectorFactory.getPrimitiveWritableObjectInspector((PrimitiveObjectInspector.PrimitiveCategory)srcTypeEntry.primitiveCategory));
                this.converters.add(ObjectInspectorConverters.getConverter((ObjectInspector)this.srcOIns.get(pos), (ObjectInspector)this.dstOIns.get(pos)));
            } else if (!this.rowTypeName.get(pos).equals(type.name())) {
                throw new RuntimeException("datatype of row changed from " + this.rowTypeName.get(pos) + " to " + type.name());
            }
            Writable w = this.row.get(pos);
            switch (type) {
                case BYTE: {
                    this.tbIn.readByte((ByteWritable)w);
                    break;
                }
                case BOOL: {
                    this.tbIn.readBoolean((BooleanWritable)w);
                    break;
                }
                case INT: {
                    this.tbIn.readInt((IntWritable)w);
                    break;
                }
                case SHORT: {
                    this.tbIn.readShort((ShortWritable)w);
                    break;
                }
                case LONG: {
                    this.tbIn.readLong((LongWritable)w);
                    break;
                }
                case FLOAT: {
                    this.tbIn.readFloat((FloatWritable)w);
                    break;
                }
                case DOUBLE: {
                    this.tbIn.readDouble((DoubleWritable)w);
                    break;
                }
                case STRING: {
                    this.tbIn.readText((Text)w);
                    break;
                }
                default: {
                    assert (false);
                    break;
                }
            }
            this.write(pos, w);
            ++pos;
        }
        return -1;
    }

    private void write(int pos, Writable inpw) throws IOException {
        String typ = this.columnTypes.get(pos);
        Writable w = (Writable)this.converters.get(pos).convert((Object)inpw);
        if (typ.equalsIgnoreCase("boolean")) {
            this.tbOut.writeBoolean((BooleanWritable)w);
        } else if (typ.equalsIgnoreCase("tinyint")) {
            this.tbOut.writeByte((ByteWritable)w);
        } else if (typ.equalsIgnoreCase("smallint")) {
            this.tbOut.writeShort((ShortWritable)w);
        } else if (typ.equalsIgnoreCase("int")) {
            this.tbOut.writeInt((IntWritable)w);
        } else if (typ.equalsIgnoreCase("bigint")) {
            this.tbOut.writeLong((LongWritable)w);
        } else if (typ.equalsIgnoreCase("float")) {
            this.tbOut.writeFloat((FloatWritable)w);
        } else if (typ.equalsIgnoreCase("double")) {
            this.tbOut.writeDouble((DoubleWritable)w);
        } else if (typ.equalsIgnoreCase("string")) {
            this.tbOut.writeText((Text)w);
        } else assert (false);
    }

    public void close() throws IOException {
        if (this.din != null) {
            this.din.close();
        }
    }

    public static Type getType(int code) {
        for (Type type : Type.values()) {
            if (type.code != code) continue;
            return type;
        }
        return null;
    }

    static {
        typedBytesToTypeName.put(TypedBytesRecordReader.getType(1), "tinyint");
        typedBytesToTypeName.put(TypedBytesRecordReader.getType(2), "boolean");
        typedBytesToTypeName.put(TypedBytesRecordReader.getType(3), "int");
        typedBytesToTypeName.put(TypedBytesRecordReader.getType(4), "bigint");
        typedBytesToTypeName.put(TypedBytesRecordReader.getType(5), "float");
        typedBytesToTypeName.put(TypedBytesRecordReader.getType(6), "double");
        typedBytesToTypeName.put(TypedBytesRecordReader.getType(7), "string");
        typedBytesToTypeName.put(TypedBytesRecordReader.getType(11), "smallint");
    }
}

