/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.newplan.logical.relational;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.pig.impl.logicalLayer.FrontendException;
import org.apache.pig.impl.util.Pair;
import org.apache.pig.newplan.Operator;
import org.apache.pig.newplan.OperatorPlan;
import org.apache.pig.newplan.PlanVisitor;
import org.apache.pig.newplan.logical.expression.LogicalExpression;
import org.apache.pig.newplan.logical.relational.LogicalRelationalNodesVisitor;
import org.apache.pig.newplan.logical.relational.LogicalRelationalOperator;
import org.apache.pig.newplan.logical.relational.LogicalSchema;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LOUnion
extends LogicalRelationalOperator {
    private List<Pair<Long, Long>> uidMapping = new ArrayList<Pair<Long, Long>>();

    public LOUnion(OperatorPlan plan) {
        super("LOUnion", plan);
    }

    @Override
    public LogicalSchema getSchema() throws FrontendException {
        int i;
        if (this.schema != null) {
            return this.schema;
        }
        List<Operator> inputs = null;
        inputs = this.plan.getPredecessors(this);
        for (Operator input : inputs) {
            LogicalRelationalOperator op = (LogicalRelationalOperator)input;
            if (op.getSchema() != null) continue;
            return null;
        }
        LogicalSchema s0 = ((LogicalRelationalOperator)inputs.get(0)).getSchema();
        if (inputs.size() == 1) {
            return s0;
        }
        LogicalSchema s1 = ((LogicalRelationalOperator)inputs.get(1)).getSchema();
        LogicalSchema mergedSchema = LogicalSchema.merge(s0, s1);
        for (i = 2; i < inputs.size(); ++i) {
            LogicalSchema otherSchema = ((LogicalRelationalOperator)inputs.get(i)).getSchema();
            if (mergedSchema == null || otherSchema == null) {
                return null;
            }
            if ((mergedSchema = LogicalSchema.merge(mergedSchema, otherSchema)) != null) continue;
            return null;
        }
        for (i = 0; i < s0.size(); ++i) {
            LogicalSchema.LogicalFieldSchema fs = mergedSchema.getField(i);
            long uid = -1L;
            for (Pair<Long, Long> pair : this.uidMapping) {
                if ((Long)pair.second != s0.getField((int)i).uid) continue;
                uid = (Long)pair.first;
                break;
            }
            if (uid == -1L) {
                uid = LogicalExpression.getNextUid();
                for (Operator input : inputs) {
                    long inputUid = ((LogicalRelationalOperator)input).getSchema().getField((int)i).uid;
                    this.uidMapping.add(new Pair<Long, Long>(uid, inputUid));
                }
            }
            fs.uid = uid;
        }
        this.schema = mergedSchema;
        return this.schema;
    }

    @Override
    public void accept(PlanVisitor v) throws FrontendException {
        if (!(v instanceof LogicalRelationalNodesVisitor)) {
            throw new FrontendException("Expected LogicalPlanVisitor", 2223);
        }
        ((LogicalRelationalNodesVisitor)v).visit(this);
    }

    @Override
    public boolean isEqual(Operator other) throws FrontendException {
        if (other != null && other instanceof LOUnion) {
            return this.checkEquality((LOUnion)other);
        }
        return false;
    }

    public Set<Long> getInputUids(long uid) {
        HashSet<Long> result = new HashSet<Long>();
        for (Pair<Long, Long> pair : this.uidMapping) {
            if ((Long)pair.first != uid) continue;
            result.add((Long)pair.second);
        }
        return result;
    }

    @Override
    public void resetUid() {
        this.uidMapping = new ArrayList<Pair<Long, Long>>();
    }
}

