/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.newplan.logical.expression;

import java.util.ArrayList;
import java.util.List;
import org.apache.pig.data.DataType;
import org.apache.pig.impl.logicalLayer.FrontendException;
import org.apache.pig.newplan.Operator;
import org.apache.pig.newplan.OperatorPlan;
import org.apache.pig.newplan.PlanVisitor;
import org.apache.pig.newplan.logical.expression.ColumnExpression;
import org.apache.pig.newplan.logical.expression.LogicalExpression;
import org.apache.pig.newplan.logical.expression.LogicalExpressionPlan;
import org.apache.pig.newplan.logical.expression.LogicalExpressionVisitor;
import org.apache.pig.newplan.logical.relational.LogicalSchema;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DereferenceExpression
extends ColumnExpression {
    private List<Integer> columns = new ArrayList<Integer>();

    public DereferenceExpression(OperatorPlan plan, int colNum) {
        super("Dereference", plan);
        this.columns.add(colNum);
        plan.add(this);
    }

    public DereferenceExpression(OperatorPlan plan, List<Integer> columnNums) {
        super("Dereference", plan);
        this.columns.addAll(columnNums);
        plan.add(this);
    }

    @Override
    public void accept(PlanVisitor v) throws FrontendException {
        if (!(v instanceof LogicalExpressionVisitor)) {
            throw new FrontendException("Expected LogicalExpressionVisitor", 2222);
        }
        ((LogicalExpressionVisitor)v).visit(this);
    }

    public List<Integer> getBagColumns() {
        return this.columns;
    }

    public void setBagColumns(List<Integer> columns) {
        this.columns = columns;
    }

    @Override
    public boolean isEqual(Operator other) throws FrontendException {
        if (other != null && other instanceof DereferenceExpression) {
            DereferenceExpression po = (DereferenceExpression)other;
            if (po.columns.size() != this.columns.size()) {
                return false;
            }
            return po.columns.containsAll(this.columns) && this.getReferredExpression().isEqual(po.getReferredExpression());
        }
        return false;
    }

    public LogicalExpression getReferredExpression() throws FrontendException {
        if (this.plan.getSuccessors(this).size() < 1) {
            throw new FrontendException("Could not find a related project Expression for Dereference", 2228);
        }
        return (LogicalExpression)this.plan.getSuccessors(this).get(0);
    }

    @Override
    public String toString() {
        StringBuilder msg = new StringBuilder();
        msg.append("(Name: " + this.name + " Type: ");
        if (this.fieldSchema != null) {
            msg.append(DataType.findTypeName(this.fieldSchema.type));
        } else {
            msg.append("null");
        }
        msg.append(" Uid: ");
        if (this.fieldSchema != null) {
            msg.append(this.fieldSchema.uid);
        } else {
            msg.append("null");
        }
        msg.append(" Column:" + this.columns);
        msg.append(")");
        return msg.toString();
    }

    @Override
    public LogicalSchema.LogicalFieldSchema getFieldSchema() throws FrontendException {
        if (this.fieldSchema != null) {
            return this.fieldSchema;
        }
        LogicalExpression successor = (LogicalExpression)this.plan.getSuccessors(this).get(0);
        LogicalSchema.LogicalFieldSchema predFS = successor.getFieldSchema();
        if (predFS != null) {
            if (this.columns.size() > 1 || predFS.type == 120) {
                LogicalSchema innerSchema = null;
                if (predFS.schema != null) {
                    innerSchema = new LogicalSchema();
                    LogicalSchema realSchema = predFS.schema.isTwoLevelAccessRequired() ? predFS.schema.getField((int)0).schema : predFS.schema;
                    if (realSchema != null) {
                        for (int column : this.columns) {
                            innerSchema.addField(realSchema.getField(column));
                        }
                    }
                }
                this.fieldSchema = new LogicalSchema.LogicalFieldSchema(null, innerSchema, predFS.type, LogicalExpression.getNextUid());
                this.uidOnlyFieldSchema = this.fieldSchema.mergeUid(this.uidOnlyFieldSchema);
            } else if (predFS.schema != null) {
                this.fieldSchema = predFS.schema.getField(this.columns.get(0));
            }
        }
        return this.fieldSchema;
    }

    @Override
    public LogicalExpression deepCopy(LogicalExpressionPlan lgExpPlan) throws FrontendException {
        ArrayList<Integer> columnsCopy = new ArrayList<Integer>(this.getBagColumns());
        DereferenceExpression copy = new DereferenceExpression((OperatorPlan)lgExpPlan, columnsCopy);
        LogicalExpression input = (LogicalExpression)this.plan.getSuccessors(this).get(0);
        LogicalExpression inputCopy = input.deepCopy(lgExpPlan);
        lgExpPlan.add(inputCopy);
        lgExpPlan.connect(copy, inputCopy);
        return copy;
    }
}

