/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.impl.logicalLayer.validators;

import java.util.ArrayList;
import java.util.List;
import org.apache.pig.impl.PigContext;
import org.apache.pig.impl.logicalLayer.LogicalOperator;
import org.apache.pig.impl.logicalLayer.LogicalPlan;
import org.apache.pig.impl.logicalLayer.validators.InputOutputFileValidator;
import org.apache.pig.impl.logicalLayer.validators.SchemaAliasValidator;
import org.apache.pig.impl.logicalLayer.validators.TypeCheckingValidator;
import org.apache.pig.impl.plan.CompilationMessageCollector;
import org.apache.pig.impl.plan.PlanValidationException;
import org.apache.pig.impl.plan.PlanValidationExecutor;
import org.apache.pig.impl.plan.PlanValidator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LogicalPlanValidationExecutor
implements PlanValidationExecutor<LogicalPlan> {
    private List<PlanValidator<LogicalOperator, LogicalPlan>> validatorList = new ArrayList<PlanValidator<LogicalOperator, LogicalPlan>>();

    public LogicalPlanValidationExecutor(LogicalPlan plan, PigContext pigContext, boolean beforeOptimizer) {
        if (!pigContext.inExplain && !beforeOptimizer) {
            this.validatorList.add(new InputOutputFileValidator(pigContext));
        } else if (beforeOptimizer) {
            this.validatorList.add(new TypeCheckingValidator());
            this.validatorList.add(new SchemaAliasValidator());
        }
    }

    @Override
    public void validate(LogicalPlan plan, CompilationMessageCollector msgCollector) throws PlanValidationException {
        if (msgCollector == null) {
            throw new AssertionError((Object)" messageCollector in LogicalPlanValidationExecutor cannot be null");
        }
        try {
            for (PlanValidator<LogicalOperator, LogicalPlan> validator : this.validatorList) {
                validator.validate(plan, msgCollector);
            }
        }
        catch (PlanValidationException pve) {
            msgCollector.collect("Severe problem found during validation " + pve.toString(), CompilationMessageCollector.MessageType.Error);
            throw pve;
        }
    }
}

