/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.impl.logicalLayer;

import java.util.ArrayList;
import java.util.List;
import org.apache.pig.EvalFunc;
import org.apache.pig.FuncSpec;
import org.apache.pig.data.DataType;
import org.apache.pig.impl.PigContext;
import org.apache.pig.impl.logicalLayer.ExpressionOperator;
import org.apache.pig.impl.logicalLayer.FrontendException;
import org.apache.pig.impl.logicalLayer.LOConst;
import org.apache.pig.impl.logicalLayer.LOVisitor;
import org.apache.pig.impl.logicalLayer.LogicalOperator;
import org.apache.pig.impl.logicalLayer.LogicalPlan;
import org.apache.pig.impl.logicalLayer.schema.Schema;
import org.apache.pig.impl.plan.OperatorKey;
import org.apache.pig.impl.plan.VisitorException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LOUserFunc
extends ExpressionOperator {
    private static final long serialVersionUID = 2L;
    private FuncSpec mFuncSpec;
    private LogicalOperator implicitReferencedOperator = null;

    public LOUserFunc(LogicalPlan plan, OperatorKey k, FuncSpec funcSpec, byte returnType) {
        super(plan, k, -1);
        this.mFuncSpec = funcSpec;
        this.mType = returnType;
    }

    public FuncSpec getFuncSpec() {
        return this.mFuncSpec;
    }

    public LogicalOperator getImplicitReferencedOperator() {
        return this.implicitReferencedOperator;
    }

    public void setImplicitReferencedOperator(LogicalOperator implicitReferencedOperator) {
        this.implicitReferencedOperator = implicitReferencedOperator;
    }

    public List<ExpressionOperator> getArguments() {
        List<LOUserFunc> preds = this.getPlan().getPredecessors(this);
        ArrayList<ExpressionOperator> args = new ArrayList<ExpressionOperator>();
        if (preds == null) {
            return args;
        }
        for (LogicalOperator logicalOperator : preds) {
            args.add((ExpressionOperator)logicalOperator);
        }
        return args;
    }

    @Override
    public boolean supportsMultipleInputs() {
        return true;
    }

    @Override
    public String name() {
        return "UserFunc " + this.mKey.scope + "-" + this.mKey.id + " function: " + this.mFuncSpec;
    }

    @Override
    public Schema getSchema() {
        return this.mSchema;
    }

    @Override
    public Schema.FieldSchema getFieldSchema() throws FrontendException {
        if (!this.mIsFieldSchemaComputed) {
            if (this.implicitReferencedOperator != null) {
                List<ExpressionOperator> args = this.getArguments();
                if (args != null && args.size() > 0) {
                    int pos = (Integer)((LOConst)this.getArguments().get(0)).getValue();
                    LogicalOperator inp = this.implicitReferencedOperator;
                    if (inp.getSchema() != null) {
                        Schema.FieldSchema inpFs = inp.getSchema().getField(pos);
                        this.mFieldSchema = Schema.FieldSchema.copyAndLink(inpFs, inp);
                    } else {
                        this.mFieldSchema = new Schema.FieldSchema(null, 50);
                        this.mFieldSchema.setParent(null, inp);
                    }
                    this.mIsFieldSchemaComputed = true;
                    return this.mFieldSchema;
                }
                return null;
            }
            Schema inputSchema = new Schema();
            List<ExpressionOperator> args = this.getArguments();
            for (ExpressionOperator op : args) {
                if (!DataType.isUsableType(op.getType())) {
                    this.mFieldSchema = null;
                    this.mIsFieldSchemaComputed = false;
                    int errCode = 1014;
                    String msg = "Problem with input: " + op + " of User-defined function: " + this;
                    throw new FrontendException(msg, errCode, 2, false, null);
                }
                inputSchema.add(op.getFieldSchema());
            }
            EvalFunc ef = (EvalFunc)PigContext.instantiateFuncFromSpec(this.mFuncSpec);
            Schema udfSchema = ef.outputSchema(inputSchema);
            byte returnType = DataType.findType(ef.getReturnType());
            if (null != udfSchema) {
                Schema.FieldSchema fs = udfSchema.size() == 0 ? new Schema.FieldSchema(null, null, returnType) : (udfSchema.size() == 1 ? new Schema.FieldSchema(udfSchema.getField(0)) : new Schema.FieldSchema(null, udfSchema, 110));
                this.setType(fs.type);
                this.mFieldSchema = fs;
                this.mIsFieldSchemaComputed = true;
            } else {
                this.setType(returnType);
                this.mFieldSchema = new Schema.FieldSchema(null, null, returnType);
                this.mIsFieldSchemaComputed = true;
            }
        }
        return this.mFieldSchema;
    }

    @Override
    public void visit(LOVisitor v) throws VisitorException {
        v.visit(this);
    }

    public void setFuncSpec(FuncSpec funcSpec) {
        this.mFuncSpec = funcSpec;
    }

    @Override
    protected Object clone() throws CloneNotSupportedException {
        LOUserFunc clone = (LOUserFunc)super.clone();
        clone.mFuncSpec = this.mFuncSpec.clone();
        return clone;
    }
}

