/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.builtin;

import java.io.IOException;
import org.apache.pig.Algebraic;
import org.apache.pig.EvalFunc;
import org.apache.pig.backend.hadoop.executionengine.mapReduceLayer.PigMapReduce;
import org.apache.pig.data.BagFactory;
import org.apache.pig.data.DataBag;
import org.apache.pig.data.InternalDistinctBag;
import org.apache.pig.data.Tuple;
import org.apache.pig.data.TupleFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Distinct
extends EvalFunc<DataBag>
implements Algebraic {
    private static BagFactory bagFactory = BagFactory.getInstance();
    private static TupleFactory tupleFactory = TupleFactory.getInstance();

    @Override
    public DataBag exec(Tuple input) throws IOException {
        return this.getDistinct(input);
    }

    @Override
    public String getFinal() {
        return Final.class.getName();
    }

    @Override
    public String getInitial() {
        return Initial.class.getName();
    }

    @Override
    public String getIntermed() {
        return Intermediate.class.getName();
    }

    private static DataBag createDataBag() {
        String bagType = null;
        if (PigMapReduce.sJobConfInternal.get() != null) {
            bagType = PigMapReduce.sJobConfInternal.get().get("pig.cachedbag.distinct.type");
        }
        if (bagType != null && bagType.equalsIgnoreCase("default")) {
            return BagFactory.getInstance().newDistinctBag();
        }
        return new InternalDistinctBag(3);
    }

    private static DataBag getDistinctFromNestedBags(Tuple input, EvalFunc evalFunc) throws IOException {
        DataBag result = Distinct.createDataBag();
        long progressCounter = 0L;
        DataBag bg = (DataBag)input.get(0);
        for (Tuple tuple : bg) {
            for (Tuple t : (DataBag)tuple.get(0)) {
                result.add(t);
                if (++progressCounter % 1000L != 0L) continue;
                evalFunc.progress();
            }
        }
        return result;
    }

    protected DataBag getDistinct(Tuple input) throws IOException {
        DataBag inputBg = (DataBag)input.get(0);
        DataBag result = Distinct.createDataBag();
        long progressCounter = 0L;
        for (Tuple tuple : inputBg) {
            result.add(tuple);
            if (++progressCounter % 1000L != 0L) continue;
            this.progress();
        }
        return result;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Final
    extends EvalFunc<DataBag> {
        @Override
        public DataBag exec(Tuple input) throws IOException {
            return Distinct.getDistinctFromNestedBags(input, this);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Intermediate
    extends EvalFunc<Tuple> {
        @Override
        public Tuple exec(Tuple input) throws IOException {
            return tupleFactory.newTuple(Distinct.getDistinctFromNestedBags(input, this));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Initial
    extends EvalFunc<Tuple> {
        @Override
        public Tuple exec(Tuple input) throws IOException {
            DataBag bag = bagFactory.newDefaultBag();
            bag.add((Tuple)input.get(0));
            return tupleFactory.newTuple(bag);
        }
    }
}

