/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.backend.hadoop.executionengine.physicalLayer.relationalOperators;

import java.util.ArrayList;
import java.util.List;
import org.apache.pig.backend.executionengine.ExecException;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.PhysicalOperator;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.Result;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.plans.PhyPlanVisitor;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.plans.PhysicalPlan;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.relationalOperators.POLocalRearrange;
import org.apache.pig.data.DataType;
import org.apache.pig.data.Tuple;
import org.apache.pig.impl.plan.NodeIdGenerator;
import org.apache.pig.impl.plan.OperatorKey;
import org.apache.pig.impl.plan.PlanException;
import org.apache.pig.impl.plan.VisitorException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class POLocalRearrangeForIllustrate
extends POLocalRearrange {
    private static final long serialVersionUID = 1L;

    public POLocalRearrangeForIllustrate(OperatorKey k) {
        this(k, -1, null);
    }

    public POLocalRearrangeForIllustrate(OperatorKey k, int rp) {
        this(k, rp, null);
    }

    public POLocalRearrangeForIllustrate(OperatorKey k, List<PhysicalOperator> inp) {
        this(k, -1, inp);
    }

    public POLocalRearrangeForIllustrate(OperatorKey k, int rp, List<PhysicalOperator> inp) {
        super(k, rp, inp);
        this.index = (byte)-1;
        this.leafOps = new ArrayList();
    }

    @Override
    public void visit(PhyPlanVisitor v) throws VisitorException {
        v.visitLocalRearrangeForIllustrate(this);
    }

    @Override
    public String name() {
        return this.getAliasString() + "Local Rearrange For Illustrate" + "[" + DataType.findTypeName(this.resultType) + "]" + "{" + DataType.findTypeName(this.keyType) + "}" + "(" + this.mIsDistinct + ") - " + this.mKey.toString();
    }

    @Override
    protected Tuple constructLROutput(List<Result> resLst, List<Result> secondaryResLst, Tuple value) throws ExecException {
        Object key;
        int i;
        if (resLst.size() > 1) {
            Tuple t = mTupleFactory.newTuple(resLst.size());
            i = -1;
            for (Result res : resLst) {
                t.set(++i, res.result);
            }
            key = t;
        } else {
            key = resLst.get((int)0).result;
        }
        Tuple output = mTupleFactory.newTuple(3);
        if (this.mIsDistinct) {
            output.set(0, (byte)0);
            output.set(1, key);
            output.set(2, this.mFakeTuple);
            return output;
        }
        if (this.isCross) {
            for (i = 0; i < this.plans.size(); ++i) {
                value.getAll().remove(0);
            }
        }
        output.set(0, this.index);
        output.set(1, key);
        output.set(2, value);
        return output;
    }

    @Override
    public POLocalRearrangeForIllustrate clone() throws CloneNotSupportedException {
        ArrayList<PhysicalPlan> clonePlans = new ArrayList<PhysicalPlan>(this.plans.size());
        for (PhysicalPlan plan : this.plans) {
            clonePlans.add(plan.clone());
        }
        POLocalRearrangeForIllustrate clone = new POLocalRearrangeForIllustrate(new OperatorKey(this.mKey.scope, NodeIdGenerator.getGenerator().getNextNodeId(this.mKey.scope)), this.requestedParallelism);
        try {
            clone.setPlans(clonePlans);
        }
        catch (PlanException pe) {
            CloneNotSupportedException cnse = new CloneNotSupportedException("Problem with setting plans of " + this.getClass().getSimpleName());
            cnse.initCause(pe);
            throw cnse;
        }
        clone.keyType = this.keyType;
        clone.index = this.index;
        clone.setDistinct(this.mIsDistinct);
        return clone;
    }
}

