/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.backend.hadoop.executionengine.physicalLayer.expressionOperators;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.pig.backend.executionengine.ExecException;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.Result;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.expressionOperators.ExpressionOperator;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.plans.PhyPlanVisitor;
import org.apache.pig.data.DataBag;
import org.apache.pig.data.DataByteArray;
import org.apache.pig.data.DataType;
import org.apache.pig.data.Tuple;
import org.apache.pig.impl.plan.NodeIdGenerator;
import org.apache.pig.impl.plan.OperatorKey;
import org.apache.pig.impl.plan.VisitorException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class POBinCond
extends ExpressionOperator {
    private static final long serialVersionUID = 1L;
    ExpressionOperator cond;
    ExpressionOperator lhs;
    ExpressionOperator rhs;
    private transient List<ExpressionOperator> child;

    public POBinCond(OperatorKey k) {
        super(k);
    }

    public POBinCond(OperatorKey k, int rp) {
        super(k, rp);
    }

    public POBinCond(OperatorKey k, int rp, ExpressionOperator cond, ExpressionOperator lhs, ExpressionOperator rhs) {
        super(k, rp);
        this.cond = cond;
        this.lhs = lhs;
        this.rhs = rhs;
    }

    @Override
    public Result getNext(Boolean b) throws ExecException {
        Result r = this.accumChild(null, b);
        if (r != null) {
            return r;
        }
        Result res = this.cond.getNext(b);
        if (res.result == null || res.returnStatus != 0) {
            return res;
        }
        return (Boolean)res.result == true ? this.lhs.getNext(b) : this.rhs.getNext(b);
    }

    @Override
    public Result getNext(DataBag db) throws ExecException {
        ArrayList<ExpressionOperator> l = new ArrayList<ExpressionOperator>();
        l.add(this.cond);
        Result r = this.accumChild(l, dummyBool);
        if (r != null) {
            if (r.returnStatus != 5) {
                return r;
            }
            l.clear();
            l.add(this.lhs);
            l.add(this.rhs);
            r = this.accumChild(l, db);
            return r;
        }
        Result res = this.cond.getNext(dummyBool);
        if (res.result == null || res.returnStatus != 0) {
            return res;
        }
        return (Boolean)res.result == true ? this.lhs.getNext(db) : this.rhs.getNext(db);
    }

    @Override
    public Result getNext(DataByteArray ba) throws ExecException {
        ArrayList<ExpressionOperator> list = new ArrayList<ExpressionOperator>();
        list.add(this.cond);
        Result r = this.accumChild(list, dummyBool);
        if (r != null) {
            if (r.returnStatus != 5) {
                return r;
            }
            list.clear();
            list.add(this.lhs);
            list.add(this.rhs);
            r = this.accumChild(list, ba);
            return r;
        }
        Result res = this.cond.getNext(dummyBool);
        if (res.result == null || res.returnStatus != 0) {
            return res;
        }
        return (Boolean)res.result == true ? this.lhs.getNext(ba) : this.rhs.getNext(ba);
    }

    @Override
    public Result getNext(Double d) throws ExecException {
        ArrayList<ExpressionOperator> list = new ArrayList<ExpressionOperator>();
        list.add(this.cond);
        Result r = this.accumChild(list, dummyBool);
        if (r != null) {
            if (r.returnStatus != 5) {
                return r;
            }
            list.clear();
            list.add(this.lhs);
            list.add(this.rhs);
            r = this.accumChild(list, d);
            return r;
        }
        Result res = this.cond.getNext(dummyBool);
        if (res.result == null || res.returnStatus != 0) {
            return res;
        }
        return (Boolean)res.result == true ? this.lhs.getNext(d) : this.rhs.getNext(d);
    }

    @Override
    public Result getNext(Float f) throws ExecException {
        ArrayList<ExpressionOperator> list = new ArrayList<ExpressionOperator>();
        list.add(this.cond);
        Result r = this.accumChild(list, dummyBool);
        if (r != null) {
            if (r.returnStatus != 5) {
                return r;
            }
            list.clear();
            list.add(this.lhs);
            list.add(this.rhs);
            r = this.accumChild(list, f);
            return r;
        }
        Result res = this.cond.getNext(dummyBool);
        if (res.result == null || res.returnStatus != 0) {
            return res;
        }
        return (Boolean)res.result == true ? this.lhs.getNext(f) : this.rhs.getNext(f);
    }

    @Override
    public Result getNext(Integer i) throws ExecException {
        ArrayList<ExpressionOperator> list = new ArrayList<ExpressionOperator>();
        list.add(this.cond);
        Result r = this.accumChild(list, dummyBool);
        if (r != null) {
            if (r.returnStatus != 5) {
                return r;
            }
            list.clear();
            list.add(this.lhs);
            list.add(this.rhs);
            r = this.accumChild(list, i);
            return r;
        }
        Result res = this.cond.getNext(dummyBool);
        if (res.result == null || res.returnStatus != 0) {
            return res;
        }
        return (Boolean)res.result == true ? this.lhs.getNext(i) : this.rhs.getNext(i);
    }

    @Override
    public Result getNext(Long l) throws ExecException {
        ArrayList<ExpressionOperator> list = new ArrayList<ExpressionOperator>();
        list.add(this.cond);
        Result r = this.accumChild(list, dummyBool);
        if (r != null) {
            if (r.returnStatus != 5) {
                return r;
            }
            list.clear();
            list.add(this.lhs);
            list.add(this.rhs);
            r = this.accumChild(list, l);
            return r;
        }
        Result res = this.cond.getNext(dummyBool);
        if (res.result == null || res.returnStatus != 0) {
            return res;
        }
        return (Boolean)res.result == true ? this.lhs.getNext(l) : this.rhs.getNext(l);
    }

    @Override
    public Result getNext(Map m) throws ExecException {
        ArrayList<ExpressionOperator> list = new ArrayList<ExpressionOperator>();
        list.add(this.cond);
        Result r = this.accumChild(list, dummyBool);
        if (r != null) {
            if (r.returnStatus != 5) {
                return r;
            }
            list.clear();
            list.add(this.lhs);
            list.add(this.rhs);
            r = this.accumChild(list, m);
            return r;
        }
        Result res = this.cond.getNext(dummyBool);
        if (res.result == null || res.returnStatus != 0) {
            return res;
        }
        return (Boolean)res.result == true ? this.lhs.getNext(m) : this.rhs.getNext(m);
    }

    @Override
    public Result getNext(String s) throws ExecException {
        ArrayList<ExpressionOperator> list = new ArrayList<ExpressionOperator>();
        list.add(this.cond);
        Result r = this.accumChild(list, dummyBool);
        if (r != null) {
            if (r.returnStatus != 5) {
                return r;
            }
            list.clear();
            list.add(this.lhs);
            list.add(this.rhs);
            r = this.accumChild(list, s);
            return r;
        }
        Result res = this.cond.getNext(dummyBool);
        if (res.result == null || res.returnStatus != 0) {
            return res;
        }
        return (Boolean)res.result == true ? this.lhs.getNext(s) : this.rhs.getNext(s);
    }

    @Override
    public Result getNext(Tuple t) throws ExecException {
        ArrayList<ExpressionOperator> list = new ArrayList<ExpressionOperator>();
        list.add(this.cond);
        Result r = this.accumChild(list, dummyBool);
        if (r != null) {
            if (r.returnStatus != 5) {
                return r;
            }
            list.clear();
            list.add(this.lhs);
            list.add(this.rhs);
            r = this.accumChild(list, t);
            return r;
        }
        Result res = this.cond.getNext(dummyBool);
        if (res.result == null || res.returnStatus != 0) {
            return res;
        }
        return (Boolean)res.result == true ? this.lhs.getNext(t) : this.rhs.getNext(t);
    }

    @Override
    public void visit(PhyPlanVisitor v) throws VisitorException {
        v.visitBinCond(this);
    }

    @Override
    public String name() {
        return "POBinCond[" + DataType.findTypeName(this.resultType) + "]" + " - " + this.mKey.toString();
    }

    @Override
    public void attachInput(Tuple t) {
        this.cond.attachInput(t);
        this.lhs.attachInput(t);
        this.rhs.attachInput(t);
    }

    public void setCond(ExpressionOperator condOp) {
        this.cond = condOp;
    }

    public void setRhs(ExpressionOperator rhs) {
        this.rhs = rhs;
    }

    public void setLhs(ExpressionOperator lhs) {
        this.lhs = lhs;
    }

    public ExpressionOperator getCond() {
        return this.cond;
    }

    public ExpressionOperator getRhs() {
        return this.rhs;
    }

    public ExpressionOperator getLhs() {
        return this.lhs;
    }

    @Override
    public boolean supportsMultipleInputs() {
        return true;
    }

    @Override
    public POBinCond clone() throws CloneNotSupportedException {
        POBinCond clone = new POBinCond(new OperatorKey(this.mKey.scope, NodeIdGenerator.getGenerator().getNextNodeId(this.mKey.scope)));
        clone.cloneHelper(this);
        clone.cond = this.cond.clone();
        clone.lhs = this.lhs.clone();
        clone.rhs = this.rhs.clone();
        return clone;
    }

    @Override
    public List<ExpressionOperator> getChildExpressions() {
        if (this.child == null) {
            this.child = new ArrayList<ExpressionOperator>();
            this.child.add(this.cond);
            this.child.add(this.lhs);
            this.child.add(this.rhs);
        }
        return this.child;
    }
}

