/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.mdr.persistence.jdbcimpl;

import java.util.AbstractSet;
import java.util.Iterator;
import org.netbeans.mdr.persistence.RuntimeStorageException;
import org.netbeans.mdr.persistence.Storage;
import org.netbeans.mdr.persistence.StorageException;
import org.netbeans.mdr.persistence.jdbcimpl.JdbcStorage;
import org.netbeans.mdr.persistence.jdbcimpl.LazyPreparedStatement;

class JdbcSet
extends AbstractSet {
    private final JdbcStorage storage;
    private final Storage.EntryType entryType;
    private final LazyPreparedStatement sqlIterator;
    private final LazyPreparedStatement sqlSize;
    private final LazyPreparedStatement sqlContains;

    JdbcSet(JdbcStorage storage, Storage.EntryType entryType, LazyPreparedStatement sqlIterator, LazyPreparedStatement sqlSize, LazyPreparedStatement sqlContains) {
        this.storage = storage;
        this.entryType = entryType;
        this.sqlIterator = sqlIterator;
        this.sqlSize = sqlSize;
        this.sqlContains = sqlContains;
    }

    public Iterator iterator() {
        try {
            return this.storage.getResultSetIterator(this.sqlIterator, null, this.entryType);
        }
        catch (StorageException ex) {
            throw new RuntimeStorageException(ex);
        }
    }

    public boolean contains(Object obj) {
        try {
            int n = this.storage.getSingletonInt(this.sqlContains, new Object[]{obj});
            return n > 0;
        }
        catch (StorageException ex) {
            throw new RuntimeStorageException(ex);
        }
    }

    public int size() {
        try {
            if (this.sqlSize != null) {
                return this.storage.getSingletonInt(this.sqlSize, null);
            }
            return this.storage.getResultSetCount(this.sqlIterator, null);
        }
        catch (StorageException ex) {
            throw new RuntimeStorageException(ex);
        }
    }
}

