/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.mdr.persistence.jdbcimpl;

import java.sql.SQLException;
import java.util.AbstractSequentialList;
import java.util.Collection;
import java.util.List;
import java.util.ListIterator;
import org.netbeans.mdr.persistence.MultivaluedOrderedIndex;
import org.netbeans.mdr.persistence.RuntimeStorageException;
import org.netbeans.mdr.persistence.SinglevaluedIndex;
import org.netbeans.mdr.persistence.Storage;
import org.netbeans.mdr.persistence.StorageException;
import org.netbeans.mdr.persistence.jdbcimpl.JdbcMultivaluedIndex;
import org.netbeans.mdr.persistence.jdbcimpl.LazyPreparedStatement;

class JdbcMultivaluedOrderedIndex
extends JdbcMultivaluedIndex
implements MultivaluedOrderedIndex {
    protected LazyPreparedStatement sqlInsertWithOrdinal;
    protected LazyPreparedStatement sqlUpdateWithOrdinal;
    protected LazyPreparedStatement sqlDeleteWithOrdinal;
    protected LazyPreparedStatement sqlShiftOrdinals;
    protected LazyPreparedStatement sqlFindOrdered;
    protected LazyPreparedStatement sqlFindValueOrdinal;

    JdbcMultivaluedOrderedIndex() {
    }

    protected void defineSql() {
        super.defineSql();
        this.sqlInsertWithOrdinal = new LazyPreparedStatement("insert into " + this.tableName + " values(?,?,?,?)");
        this.sqlUpdateWithOrdinal = new LazyPreparedStatement("update " + this.tableName + " set " + this.valColName + " = ? where " + this.keyColName + " = ? and " + "IDX_ORD" + " = ?");
        this.sqlDeleteWithOrdinal = new LazyPreparedStatement("delete from " + this.tableName + " where " + this.keyColName + " = ?" + " and " + "IDX_ORD" + " = ?");
        this.sqlShiftOrdinals = new LazyPreparedStatement("update " + this.tableName + " set " + "IDX_ORD" + " = " + "IDX_ORD" + " + ? where " + this.keyColName + " = ? and " + "IDX_ORD" + " >= ?");
        String selectOrdered = "select " + this.valColName;
        boolean orderByUnrelated = false;
        try {
            orderByUnrelated = this.storage.getDatabaseMetaData().supportsOrderByUnrelated();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        if (!orderByUnrelated) {
            selectOrdered = selectOrdered + ", " + this.keyColName + ", " + "IDX_ORD";
        }
        this.sqlFindOrdered = new LazyPreparedStatement(selectOrdered + " from " + this.tableName + " where " + this.keyColName + " = ? order by " + this.keyColName + ", " + "IDX_ORD");
        this.sqlFindValueOrdinal = new LazyPreparedStatement("select IDX_ORD from " + this.tableName + " where " + this.keyColName + " = ?" + " and " + this.valColName + " = ?");
    }

    public List getItemsOrdered(Object key) throws StorageException {
        return new ItemList(key, null);
    }

    public Collection getObjectsOrdered(Object key, SinglevaluedIndex repos) throws StorageException {
        if (this.keyType == Storage.EntryType.MOFID) {
            return new ItemList(key, repos);
        }
        return this.getItemsOrdered(key);
    }

    public void add(Object key, int index, Object value) throws StorageException {
        this.addImpl(key, index, value, true);
    }

    protected void addImpl(Object key, Object value) throws StorageException {
        int index = this.getItemsOrdered(key).size();
        this.addImpl(key, index, value, false);
    }

    private void addImpl(Object key, int index, Object value, boolean shiftOrdinals) throws StorageException {
        if (shiftOrdinals) {
            this.storage.executeUpdate(this.sqlShiftOrdinals, new Object[]{new Integer(1), key, new Integer(index)});
        }
        Object[] args = new Object[]{key, value, new Integer(index), new Long(this.storage.getSerialNumber())};
        this.storage.executeUpdate(this.sqlInsertWithOrdinal, args);
    }

    public boolean remove(Object key, int index) throws StorageException {
        return this.removeImpl(key, index, true);
    }

    public boolean remove(Object key, Object value) throws StorageException {
        int index = this.storage.getSingletonInt(this.sqlFindValueOrdinal, new Object[]{key, value});
        if (index == -1) {
            return false;
        }
        this.remove(key, index);
        return true;
    }

    private boolean removeImpl(Object key, int index, boolean shiftOrdinals) throws StorageException {
        this.storage.executeUpdate(this.sqlDeleteWithOrdinal, new Object[]{key, new Integer(index)});
        if (shiftOrdinals) {
            this.storage.executeUpdate(this.sqlShiftOrdinals, new Object[]{new Integer(-1), key, new Integer(index)});
        }
        return true;
    }

    public void replace(Object key, int index, Object element) throws StorageException {
        this.storage.executeUpdate(this.sqlUpdateWithOrdinal, new Object[]{element, key, new Integer(index)});
    }

    private class ItemListIter
    implements ListIterator {
        private ListIterator iter;
        private SinglevaluedIndex repos;
        private Object key;
        private int lastPos;

        ItemListIter(ListIterator iter, SinglevaluedIndex repos, Object key) {
            this.iter = iter;
            this.repos = repos;
            this.key = key;
            this.lastPos = -1;
        }

        public void add(Object obj) {
            try {
                int index = this.nextIndex();
                JdbcMultivaluedOrderedIndex.this.addImpl(this.key, index, obj, this.iter.hasNext());
            }
            catch (StorageException ex) {
                throw new RuntimeStorageException(ex);
            }
            this.iter.add(obj);
            this.lastPos = -1;
        }

        public boolean hasNext() {
            return this.iter.hasNext();
        }

        public boolean hasPrevious() {
            return this.iter.hasPrevious();
        }

        private Object getValue(Object obj) {
            if (this.repos != null) {
                try {
                    return this.repos.get(obj);
                }
                catch (StorageException ex) {
                    throw new RuntimeStorageException(ex);
                }
            }
            return obj;
        }

        public Object next() {
            this.lastPos = this.iter.nextIndex();
            return this.getValue(this.iter.next());
        }

        public int nextIndex() {
            return this.iter.nextIndex();
        }

        public Object previous() {
            this.lastPos = this.iter.previousIndex();
            return this.getValue(this.iter.previous());
        }

        public int previousIndex() {
            return this.iter.previousIndex();
        }

        public void remove() {
            if (this.lastPos == -1) {
                throw new IllegalStateException();
            }
            this.iter.remove();
            try {
                JdbcMultivaluedOrderedIndex.this.removeImpl(this.key, this.lastPos, this.iter.hasNext());
            }
            catch (StorageException ex) {
                throw new RuntimeStorageException(ex);
            }
            this.lastPos = -1;
        }

        public void set(Object obj) {
            this.iter.set(obj);
            try {
                JdbcMultivaluedOrderedIndex.this.replace(this.key, this.lastPos, obj);
            }
            catch (StorageException ex) {
                throw new RuntimeStorageException(ex);
            }
            this.lastPos = -1;
        }
    }

    private class ItemList
    extends AbstractSequentialList {
        private Object key;
        private SinglevaluedIndex repos;

        ItemList(Object key, SinglevaluedIndex repos) {
            this.key = key;
            this.repos = repos;
        }

        public ListIterator listIterator(int index) {
            try {
                ItemListIter iter = new ItemListIter(JdbcMultivaluedOrderedIndex.this.storage.getResultSetIterator(JdbcMultivaluedOrderedIndex.this.sqlFindOrdered, new Object[]{this.key}, JdbcMultivaluedOrderedIndex.this.getValueType()), this.repos, this.key);
                while (iter.nextIndex() != index) {
                    iter.next();
                }
                return iter;
            }
            catch (StorageException ex) {
                throw new RuntimeStorageException(ex);
            }
        }

        public int size() {
            try {
                return JdbcMultivaluedOrderedIndex.this.storage.getSingletonInt(JdbcMultivaluedOrderedIndex.this.sqlFindCount, new Object[]{this.key});
            }
            catch (StorageException ex) {
                throw new RuntimeStorageException(ex);
            }
        }
    }
}

