/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.pms.schema;

import java.util.List;
import org.pentaho.di.core.changed.ChangedFlag;
import org.pentaho.di.core.changed.ChangedFlagInterface;
import org.pentaho.di.core.xml.XMLHandler;
import org.pentaho.di.core.xml.XMLInterface;
import org.pentaho.pms.core.exception.PentahoMetadataException;
import org.pentaho.pms.mql.PMSFormula;
import org.pentaho.pms.schema.BusinessColumn;
import org.pentaho.pms.schema.BusinessModel;
import org.pentaho.pms.schema.BusinessTable;
import org.pentaho.pms.util.Const;
import org.w3c.dom.Node;

public class RelationshipMeta
extends ChangedFlag
implements Cloneable,
XMLInterface,
ChangedFlagInterface {
    private BusinessTable table_from;
    private BusinessTable table_to;
    private BusinessColumn field_from;
    private BusinessColumn field_to;
    private int type;
    private boolean complex;
    private String complex_join;
    private String joinOrderKey;
    private String description;
    private List<BusinessColumn> cjReferencedColumns;
    public static final int TYPE_RELATIONSHIP_UNDEFINED = 0;
    public static final int TYPE_RELATIONSHIP_1_N = 1;
    public static final int TYPE_RELATIONSHIP_N_1 = 2;
    public static final int TYPE_RELATIONSHIP_1_1 = 3;
    public static final int TYPE_RELATIONSHIP_0_N = 4;
    public static final int TYPE_RELATIONSHIP_N_0 = 5;
    public static final int TYPE_RELATIONSHIP_0_1 = 6;
    public static final int TYPE_RELATIONSHIP_1_0 = 7;
    public static final int TYPE_RELATIONSHIP_N_N = 8;
    public static final int TYPE_RELATIONSHIP_0_0 = 9;
    public static final String[] typeRelationshipDesc = new String[]{"undefined", "1:N", "N:1", "1:1", "0:N", "N:0", "0:1", "1:0", "N:N", "0:0"};
    public static final int TYPE_JOIN_INNER = 0;
    public static final int TYPE_JOIN_LEFT_OUTER = 1;
    public static final int TYPE_JOIN_RIGHT_OUTER = 2;
    public static final int TYPE_JOIN_FULL_OUTER = 3;
    public static final String[] typeJoinDesc = new String[]{"Inner", "Left outer", "Right outer", "Full outer"};

    public RelationshipMeta() {
        this.type = 0;
        this.complex = false;
        this.complex_join = "";
    }

    public RelationshipMeta(BusinessTable table_from, BusinessTable table_to, BusinessColumn field_from, BusinessColumn field_to) {
        this();
        this.table_from = table_from;
        this.table_to = table_to;
        this.field_from = field_from;
        this.field_to = field_to;
    }

    public RelationshipMeta(BusinessTable table_from, BusinessTable table_to, String complex_join) {
        this.table_from = table_from;
        this.table_to = table_to;
        this.field_from = null;
        this.field_to = null;
        this.type = 0;
        this.complex = true;
        this.complex_join = complex_join;
    }

    public boolean loadXML(Node relnode, List tables) {
        try {
            String from = XMLHandler.getTagValue((Node)relnode, (String)"table_from");
            this.table_from = this.findTable(tables, from);
            String to = XMLHandler.getTagValue((Node)relnode, (String)"table_to");
            this.table_to = this.findTable(tables, to);
            if (this.table_from != null) {
                this.field_from = this.table_from.findBusinessColumn(XMLHandler.getTagValue((Node)relnode, (String)"field_from"));
            }
            if (this.table_to != null) {
                this.field_to = this.table_to.findBusinessColumn(XMLHandler.getTagValue((Node)relnode, (String)"field_to"));
            }
            this.type = RelationshipMeta.getType(XMLHandler.getTagValue((Node)relnode, (String)"type"));
            this.complex = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)relnode, (String)"complex"));
            this.complex_join = XMLHandler.getTagValue((Node)relnode, (String)"complex_join");
            this.joinOrderKey = XMLHandler.getTagValue((Node)relnode, (String)"join_order_key");
            this.description = XMLHandler.getTagValue((Node)relnode, (String)"description");
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public String getXML() {
        String retval = "";
        retval = retval + "      <relationship>" + Const.CR;
        retval = retval + "        " + XMLHandler.addTagValue((String)"table_from", (String)this.table_from.getId());
        retval = retval + "        " + XMLHandler.addTagValue((String)"table_to", (String)this.table_to.getId());
        retval = retval + "        " + XMLHandler.addTagValue((String)"field_from", (String)(this.field_from != null ? this.field_from.getId() : ""));
        retval = retval + "        " + XMLHandler.addTagValue((String)"field_to", (String)(this.field_to != null ? this.field_to.getId() : ""));
        retval = retval + "        " + XMLHandler.addTagValue((String)"type", (String)this.getTypeDesc());
        retval = retval + "        " + XMLHandler.addTagValue((String)"complex", (boolean)this.complex);
        retval = retval + "        " + XMLHandler.addTagValue((String)"complex_join", (String)this.complex_join);
        retval = retval + "        " + XMLHandler.addTagValue((String)"join_order_key", (String)this.joinOrderKey);
        retval = retval + "        " + XMLHandler.addTagValue((String)"description", (String)this.description);
        retval = retval + "      </relationship>" + Const.CR;
        return retval;
    }

    private BusinessTable findTable(List tables, String name) {
        for (int x = 0; x < tables.size(); ++x) {
            BusinessTable tableinfo = (BusinessTable)tables.get(x);
            if (!tableinfo.getId().equalsIgnoreCase(name)) continue;
            return tableinfo;
        }
        return null;
    }

    public Object clone() {
        try {
            RelationshipMeta retval = (RelationshipMeta)super.clone();
            retval.setTableFrom((BusinessTable)this.getTableFrom().clone());
            retval.setTableTo((BusinessTable)this.getTableTo().clone());
            return retval;
        }
        catch (CloneNotSupportedException e) {
            return null;
        }
    }

    public void setTableFrom(BusinessTable table_from) {
        this.table_from = table_from;
    }

    public BusinessTable getTableFrom() {
        return this.table_from;
    }

    public void setTableTo(BusinessTable table_to) {
        this.table_to = table_to;
    }

    public BusinessTable getTableTo() {
        return this.table_to;
    }

    public void setFieldFrom(BusinessColumn field_from) {
        this.field_from = field_from;
    }

    public void setFieldTo(BusinessColumn field_to) {
        this.field_to = field_to;
    }

    public BusinessColumn getFieldFrom() {
        return this.field_from;
    }

    public BusinessColumn getFieldTo() {
        return this.field_to;
    }

    public boolean isComplex() {
        return this.complex;
    }

    public boolean isRegular() {
        return !this.complex;
    }

    public void setComplex() {
        this.setComplex(true);
    }

    public void setRegular() {
        this.setComplex(false);
    }

    public void flipComplex() {
        this.setComplex(!this.isComplex());
    }

    public void setComplex(boolean c) {
        this.complex = c;
    }

    public String getComplexJoin() {
        return this.complex_join;
    }

    public List<BusinessColumn> getCJReferencedColumns() {
        return this.cjReferencedColumns;
    }

    public void setCJReferencedColumns(List<BusinessColumn> cjReferencedColumns) {
        this.cjReferencedColumns = cjReferencedColumns;
    }

    public void setComplexJoin(String cj) {
        this.complex_join = cj;
    }

    public int getType() {
        return this.type;
    }

    public void setType(int type) {
        this.type = type;
    }

    public void setType(String tdesc) {
        this.type = RelationshipMeta.getType(tdesc);
    }

    public String getTypeDesc() {
        return RelationshipMeta.getType(this.type);
    }

    public static final String getType(int i) {
        return typeRelationshipDesc[i];
    }

    public static final int getType(String typedesc) {
        for (int i = 0; i < typeRelationshipDesc.length; ++i) {
            if (!typeRelationshipDesc[i].equalsIgnoreCase(typedesc)) continue;
            return i;
        }
        return 0;
    }

    public boolean isUsingTable(BusinessTable table) {
        if (table == null) {
            return false;
        }
        return table.equals(this.table_from) || table.equals(this.table_to);
    }

    public void flip() {
        BusinessTable dummy = this.table_from;
        this.table_from = this.table_to;
        this.table_to = dummy;
        BusinessColumn dum = this.field_from;
        this.field_from = this.field_to;
        this.field_to = dum;
        switch (this.type) {
            case 0: {
                break;
            }
            case 1: {
                this.type = 2;
                break;
            }
            case 2: {
                this.type = 1;
                break;
            }
            case 3: {
                break;
            }
            case 4: {
                this.type = 5;
                break;
            }
            case 5: {
                this.type = 4;
                break;
            }
            case 6: {
                this.type = 7;
                break;
            }
            case 7: {
                this.type = 6;
                break;
            }
        }
    }

    public String toString() {
        if (this.field_from != null && this.field_to != null) {
            return this.table_from.getId() + "." + this.field_from.getId() + " - " + this.table_to.getId() + "." + this.field_to.getId();
        }
        try {
            return this.table_from.getId() + " - " + this.table_to.getId();
        }
        catch (Exception e) {
            return "??????????";
        }
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    public boolean equals(Object obj) {
        RelationshipMeta rel = (RelationshipMeta)obj;
        return rel.table_from.equals(this.table_from) && rel.table_to.equals(this.table_to);
    }

    public void clearChanged() {
        this.setChanged(false);
    }

    public int getJoinType() {
        return RelationshipMeta.getJoinType(this.type);
    }

    public static int getJoinType(int relationshipType) {
        switch (relationshipType) {
            case 4: {
                return 1;
            }
            case 5: {
                return 2;
            }
            case 6: {
                return 1;
            }
            case 7: {
                return 2;
            }
            case 9: {
                return 3;
            }
        }
        return 0;
    }

    public static int getRelationType(int joinType) {
        switch (joinType) {
            case 1: {
                return 4;
            }
            case 2: {
                return 5;
            }
            case 3: {
                return 9;
            }
        }
        return 8;
    }

    public String getJoinTypeDesc() {
        return typeJoinDesc[this.getJoinType()];
    }

    public boolean isOuterJoin() {
        return this.getJoinType() != 0;
    }

    public String getJoinOrderKey() {
        return this.joinOrderKey;
    }

    public void setJoinOrderKey(String joinOrderKey) {
        this.joinOrderKey = joinOrderKey;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public PMSFormula getComplexJoinFormula(BusinessModel model) throws PentahoMetadataException {
        if (!this.isComplex()) {
            return null;
        }
        return new PMSFormula(model, this.getComplexJoin(), null);
    }
}

